/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.postgresql;

import eu.dnet.researcher.postgresql.Researcher;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.List;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="researcher")
public class Researcher {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="fullname")
    private String fullname;
    @Column(name="fullname_source")
    private String fullnameSource;
    @Column(name="fullname_visibility")
    private Boolean fullnameVisibility;
    @Column(name="bio", columnDefinition="TEXT")
    private String bio;
    @Column(name="bio_source")
    private String bioSource;
    @Column(name="bio_visibility")
    private Boolean bioVisibility;
    private List<String> emails;
    @Column(name="orcid")
    private String orcid;
    @Column(name="openaire_id")
    private String openaireId;
    @CreationTimestamp
    @Column(name="created_at", updatable=false)
    private LocalDateTime creationDate;
    @UpdateTimestamp
    @Column(name="updated_at")
    private LocalDateTime modificationDate;

    public static ResearcherBuilder builder() {
        return new ResearcherBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getFullnameSource() {
        return this.fullnameSource;
    }

    public Boolean getFullnameVisibility() {
        return this.fullnameVisibility;
    }

    public String getBio() {
        return this.bio;
    }

    public String getBioSource() {
        return this.bioSource;
    }

    public Boolean getBioVisibility() {
        return this.bioVisibility;
    }

    public List<String> getEmails() {
        return this.emails;
    }

    public String getOrcid() {
        return this.orcid;
    }

    public String getOpenaireId() {
        return this.openaireId;
    }

    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    public LocalDateTime getModificationDate() {
        return this.modificationDate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public void setFullnameSource(String fullnameSource) {
        this.fullnameSource = fullnameSource;
    }

    public void setFullnameVisibility(Boolean fullnameVisibility) {
        this.fullnameVisibility = fullnameVisibility;
    }

    public void setBio(String bio) {
        this.bio = bio;
    }

    public void setBioSource(String bioSource) {
        this.bioSource = bioSource;
    }

    public void setBioVisibility(Boolean bioVisibility) {
        this.bioVisibility = bioVisibility;
    }

    public void setEmails(List<String> emails) {
        this.emails = emails;
    }

    public void setOrcid(String orcid) {
        this.orcid = orcid;
    }

    public void setOpenaireId(String openaireId) {
        this.openaireId = openaireId;
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public void setModificationDate(LocalDateTime modificationDate) {
        this.modificationDate = modificationDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Researcher)) {
            return false;
        }
        Researcher other = (Researcher)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$fullnameVisibility = this.getFullnameVisibility();
        Boolean other$fullnameVisibility = other.getFullnameVisibility();
        if (this$fullnameVisibility == null ? other$fullnameVisibility != null : !((Object)this$fullnameVisibility).equals(other$fullnameVisibility)) {
            return false;
        }
        Boolean this$bioVisibility = this.getBioVisibility();
        Boolean other$bioVisibility = other.getBioVisibility();
        if (this$bioVisibility == null ? other$bioVisibility != null : !((Object)this$bioVisibility).equals(other$bioVisibility)) {
            return false;
        }
        String this$fullname = this.getFullname();
        String other$fullname = other.getFullname();
        if (this$fullname == null ? other$fullname != null : !this$fullname.equals(other$fullname)) {
            return false;
        }
        String this$fullnameSource = this.getFullnameSource();
        String other$fullnameSource = other.getFullnameSource();
        if (this$fullnameSource == null ? other$fullnameSource != null : !this$fullnameSource.equals(other$fullnameSource)) {
            return false;
        }
        String this$bio = this.getBio();
        String other$bio = other.getBio();
        if (this$bio == null ? other$bio != null : !this$bio.equals(other$bio)) {
            return false;
        }
        String this$bioSource = this.getBioSource();
        String other$bioSource = other.getBioSource();
        if (this$bioSource == null ? other$bioSource != null : !this$bioSource.equals(other$bioSource)) {
            return false;
        }
        List this$emails = this.getEmails();
        List other$emails = other.getEmails();
        if (this$emails == null ? other$emails != null : !((Object)this$emails).equals(other$emails)) {
            return false;
        }
        String this$orcid = this.getOrcid();
        String other$orcid = other.getOrcid();
        if (this$orcid == null ? other$orcid != null : !this$orcid.equals(other$orcid)) {
            return false;
        }
        String this$openaireId = this.getOpenaireId();
        String other$openaireId = other.getOpenaireId();
        if (this$openaireId == null ? other$openaireId != null : !this$openaireId.equals(other$openaireId)) {
            return false;
        }
        LocalDateTime this$creationDate = this.getCreationDate();
        LocalDateTime other$creationDate = other.getCreationDate();
        if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
            return false;
        }
        LocalDateTime this$modificationDate = this.getModificationDate();
        LocalDateTime other$modificationDate = other.getModificationDate();
        return !(this$modificationDate == null ? other$modificationDate != null : !((Object)this$modificationDate).equals(other$modificationDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Researcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $fullnameVisibility = this.getFullnameVisibility();
        result = result * 59 + ($fullnameVisibility == null ? 43 : ((Object)$fullnameVisibility).hashCode());
        Boolean $bioVisibility = this.getBioVisibility();
        result = result * 59 + ($bioVisibility == null ? 43 : ((Object)$bioVisibility).hashCode());
        String $fullname = this.getFullname();
        result = result * 59 + ($fullname == null ? 43 : $fullname.hashCode());
        String $fullnameSource = this.getFullnameSource();
        result = result * 59 + ($fullnameSource == null ? 43 : $fullnameSource.hashCode());
        String $bio = this.getBio();
        result = result * 59 + ($bio == null ? 43 : $bio.hashCode());
        String $bioSource = this.getBioSource();
        result = result * 59 + ($bioSource == null ? 43 : $bioSource.hashCode());
        List $emails = this.getEmails();
        result = result * 59 + ($emails == null ? 43 : ((Object)$emails).hashCode());
        String $orcid = this.getOrcid();
        result = result * 59 + ($orcid == null ? 43 : $orcid.hashCode());
        String $openaireId = this.getOpenaireId();
        result = result * 59 + ($openaireId == null ? 43 : $openaireId.hashCode());
        LocalDateTime $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
        LocalDateTime $modificationDate = this.getModificationDate();
        result = result * 59 + ($modificationDate == null ? 43 : ((Object)$modificationDate).hashCode());
        return result;
    }

    public String toString() {
        return "Researcher(id=" + this.getId() + ", fullname=" + this.getFullname() + ", fullnameSource=" + this.getFullnameSource() + ", fullnameVisibility=" + this.getFullnameVisibility() + ", bio=" + this.getBio() + ", bioSource=" + this.getBioSource() + ", bioVisibility=" + this.getBioVisibility() + ", emails=" + String.valueOf(this.getEmails()) + ", orcid=" + this.getOrcid() + ", openaireId=" + this.getOpenaireId() + ", creationDate=" + String.valueOf(this.getCreationDate()) + ", modificationDate=" + String.valueOf(this.getModificationDate()) + ")";
    }

    public Researcher() {
    }

    public Researcher(Long id, String fullname, String fullnameSource, Boolean fullnameVisibility, String bio, String bioSource, Boolean bioVisibility, List<String> emails, String orcid, String openaireId, LocalDateTime creationDate, LocalDateTime modificationDate) {
        this.id = id;
        this.fullname = fullname;
        this.fullnameSource = fullnameSource;
        this.fullnameVisibility = fullnameVisibility;
        this.bio = bio;
        this.bioSource = bioSource;
        this.bioVisibility = bioVisibility;
        this.emails = emails;
        this.orcid = orcid;
        this.openaireId = openaireId;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
    }
}

