/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.postgresql;

import eu.dnet.researcher.postgresql.Activity;
import eu.dnet.researcher.postgresql.Funding;
import eu.dnet.researcher.postgresql.ResearcherEmail;
import eu.dnet.researcher.postgresql.ResearcherPid;
import eu.dnet.researcher.postgresql.ResearcherProfile;
import eu.dnet.researcher.postgresql.TimePeriod;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="researcher")
public class ResearcherProfile {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(columnDefinition="TEXT")
    private String bio;
    @Column(name="openaire_id", length=255)
    private String openaireId;
    @CreationTimestamp
    @Column(name="created_at", updatable=false)
    private Instant createdAt;
    @UpdateTimestamp
    @Column(name="updated_at")
    private Instant updatedAt;
    @Column(length=255)
    private String source;
    @Column(name="profile_visibility")
    private Boolean profileVisibility = true;
    @Column(length=255)
    private String orcid;
    @Column(length=255)
    private String fullname;
    @Column(length=255)
    private String firstname;
    @Column(length=255)
    private String lastname;
    @Column(name="fullname_source", length=255)
    private String fullnameSource;
    @Column(name="bio_source", length=255)
    private String bioSource;
    @Column(name="title", length=255)
    private String title;
    @OneToMany(mappedBy="researcher", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ResearcherEmail> emails = new ArrayList();
    @OneToMany(mappedBy="researcher", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ResearcherPid> pids = new ArrayList();
    @OneToMany(mappedBy="researcher", cascade={CascadeType.ALL}, orphanRemoval=false)
    private List<Activity> activities = new ArrayList();
    @OneToMany(mappedBy="researcher", cascade={CascadeType.ALL}, orphanRemoval=false)
    private List<Funding> fundings = new ArrayList();
    @OneToMany(mappedBy="researcher", cascade={CascadeType.ALL}, orphanRemoval=false)
    private List<TimePeriod> timeline = new ArrayList();

    public static ResearcherProfileBuilder builder() {
        return new ResearcherProfileBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getBio() {
        return this.bio;
    }

    public String getOpenaireId() {
        return this.openaireId;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public String getSource() {
        return this.source;
    }

    public Boolean getProfileVisibility() {
        return this.profileVisibility;
    }

    public String getOrcid() {
        return this.orcid;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getFullnameSource() {
        return this.fullnameSource;
    }

    public String getBioSource() {
        return this.bioSource;
    }

    public String getTitle() {
        return this.title;
    }

    public List<ResearcherEmail> getEmails() {
        return this.emails;
    }

    public List<ResearcherPid> getPids() {
        return this.pids;
    }

    public List<Activity> getActivities() {
        return this.activities;
    }

    public List<Funding> getFundings() {
        return this.fundings;
    }

    public List<TimePeriod> getTimeline() {
        return this.timeline;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setBio(String bio) {
        this.bio = bio;
    }

    public void setOpenaireId(String openaireId) {
        this.openaireId = openaireId;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setProfileVisibility(Boolean profileVisibility) {
        this.profileVisibility = profileVisibility;
    }

    public void setOrcid(String orcid) {
        this.orcid = orcid;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public void setFullnameSource(String fullnameSource) {
        this.fullnameSource = fullnameSource;
    }

    public void setBioSource(String bioSource) {
        this.bioSource = bioSource;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setEmails(List<ResearcherEmail> emails) {
        this.emails = emails;
    }

    public void setPids(List<ResearcherPid> pids) {
        this.pids = pids;
    }

    public void setActivities(List<Activity> activities) {
        this.activities = activities;
    }

    public void setFundings(List<Funding> fundings) {
        this.fundings = fundings;
    }

    public void setTimeline(List<TimePeriod> timeline) {
        this.timeline = timeline;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResearcherProfile)) {
            return false;
        }
        ResearcherProfile other = (ResearcherProfile)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$profileVisibility = this.getProfileVisibility();
        Boolean other$profileVisibility = other.getProfileVisibility();
        if (this$profileVisibility == null ? other$profileVisibility != null : !((Object)this$profileVisibility).equals(other$profileVisibility)) {
            return false;
        }
        String this$bio = this.getBio();
        String other$bio = other.getBio();
        if (this$bio == null ? other$bio != null : !this$bio.equals(other$bio)) {
            return false;
        }
        String this$openaireId = this.getOpenaireId();
        String other$openaireId = other.getOpenaireId();
        if (this$openaireId == null ? other$openaireId != null : !this$openaireId.equals(other$openaireId)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$orcid = this.getOrcid();
        String other$orcid = other.getOrcid();
        if (this$orcid == null ? other$orcid != null : !this$orcid.equals(other$orcid)) {
            return false;
        }
        String this$fullname = this.getFullname();
        String other$fullname = other.getFullname();
        if (this$fullname == null ? other$fullname != null : !this$fullname.equals(other$fullname)) {
            return false;
        }
        String this$firstname = this.getFirstname();
        String other$firstname = other.getFirstname();
        if (this$firstname == null ? other$firstname != null : !this$firstname.equals(other$firstname)) {
            return false;
        }
        String this$lastname = this.getLastname();
        String other$lastname = other.getLastname();
        if (this$lastname == null ? other$lastname != null : !this$lastname.equals(other$lastname)) {
            return false;
        }
        String this$fullnameSource = this.getFullnameSource();
        String other$fullnameSource = other.getFullnameSource();
        if (this$fullnameSource == null ? other$fullnameSource != null : !this$fullnameSource.equals(other$fullnameSource)) {
            return false;
        }
        String this$bioSource = this.getBioSource();
        String other$bioSource = other.getBioSource();
        if (this$bioSource == null ? other$bioSource != null : !this$bioSource.equals(other$bioSource)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List this$emails = this.getEmails();
        List other$emails = other.getEmails();
        if (this$emails == null ? other$emails != null : !((Object)this$emails).equals(other$emails)) {
            return false;
        }
        List this$pids = this.getPids();
        List other$pids = other.getPids();
        if (this$pids == null ? other$pids != null : !((Object)this$pids).equals(other$pids)) {
            return false;
        }
        List this$activities = this.getActivities();
        List other$activities = other.getActivities();
        if (this$activities == null ? other$activities != null : !((Object)this$activities).equals(other$activities)) {
            return false;
        }
        List this$fundings = this.getFundings();
        List other$fundings = other.getFundings();
        if (this$fundings == null ? other$fundings != null : !((Object)this$fundings).equals(other$fundings)) {
            return false;
        }
        List this$timeline = this.getTimeline();
        List other$timeline = other.getTimeline();
        return !(this$timeline == null ? other$timeline != null : !((Object)this$timeline).equals(other$timeline));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResearcherProfile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $profileVisibility = this.getProfileVisibility();
        result = result * 59 + ($profileVisibility == null ? 43 : ((Object)$profileVisibility).hashCode());
        String $bio = this.getBio();
        result = result * 59 + ($bio == null ? 43 : $bio.hashCode());
        String $openaireId = this.getOpenaireId();
        result = result * 59 + ($openaireId == null ? 43 : $openaireId.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $orcid = this.getOrcid();
        result = result * 59 + ($orcid == null ? 43 : $orcid.hashCode());
        String $fullname = this.getFullname();
        result = result * 59 + ($fullname == null ? 43 : $fullname.hashCode());
        String $firstname = this.getFirstname();
        result = result * 59 + ($firstname == null ? 43 : $firstname.hashCode());
        String $lastname = this.getLastname();
        result = result * 59 + ($lastname == null ? 43 : $lastname.hashCode());
        String $fullnameSource = this.getFullnameSource();
        result = result * 59 + ($fullnameSource == null ? 43 : $fullnameSource.hashCode());
        String $bioSource = this.getBioSource();
        result = result * 59 + ($bioSource == null ? 43 : $bioSource.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List $emails = this.getEmails();
        result = result * 59 + ($emails == null ? 43 : ((Object)$emails).hashCode());
        List $pids = this.getPids();
        result = result * 59 + ($pids == null ? 43 : ((Object)$pids).hashCode());
        List $activities = this.getActivities();
        result = result * 59 + ($activities == null ? 43 : ((Object)$activities).hashCode());
        List $fundings = this.getFundings();
        result = result * 59 + ($fundings == null ? 43 : ((Object)$fundings).hashCode());
        List $timeline = this.getTimeline();
        result = result * 59 + ($timeline == null ? 43 : ((Object)$timeline).hashCode());
        return result;
    }

    public String toString() {
        return "ResearcherProfile(id=" + this.getId() + ", bio=" + this.getBio() + ", openaireId=" + this.getOpenaireId() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", source=" + this.getSource() + ", profileVisibility=" + this.getProfileVisibility() + ", orcid=" + this.getOrcid() + ", fullname=" + this.getFullname() + ", firstname=" + this.getFirstname() + ", lastname=" + this.getLastname() + ", fullnameSource=" + this.getFullnameSource() + ", bioSource=" + this.getBioSource() + ", title=" + this.getTitle() + ", emails=" + String.valueOf(this.getEmails()) + ", pids=" + String.valueOf(this.getPids()) + ", activities=" + String.valueOf(this.getActivities()) + ", fundings=" + String.valueOf(this.getFundings()) + ", timeline=" + String.valueOf(this.getTimeline()) + ")";
    }

    public ResearcherProfile() {
    }

    public ResearcherProfile(Long id, String bio, String openaireId, Instant createdAt, Instant updatedAt, String source, Boolean profileVisibility, String orcid, String fullname, String firstname, String lastname, String fullnameSource, String bioSource, String title, List<ResearcherEmail> emails, List<ResearcherPid> pids, List<Activity> activities, List<Funding> fundings, List<TimePeriod> timeline) {
        this.id = id;
        this.bio = bio;
        this.openaireId = openaireId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.source = source;
        this.profileVisibility = profileVisibility;
        this.orcid = orcid;
        this.fullname = fullname;
        this.firstname = firstname;
        this.lastname = lastname;
        this.fullnameSource = fullnameSource;
        this.bioSource = bioSource;
        this.title = title;
        this.emails = emails;
        this.pids = pids;
        this.activities = activities;
        this.fundings = fundings;
        this.timeline = timeline;
    }
}

