/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.postgresql;

import com.fasterxml.jackson.annotation.JsonFormat;
import eu.dnet.researcher.postgresql.ResearcherProfile;
import eu.dnet.researcher.postgresql.TimePeriod;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.List;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
@Table(name="time_period")
public class TimePeriod {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    @JoinColumn(name="researcher_id", nullable=false)
    private ResearcherProfile researcher;
    @Column(name="title", length=255)
    private String title;
    @Column(name="description", columnDefinition="TEXT")
    private String description;
    @Column(name="from_date")
    @NotNull(message="from date can not be null")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private @NotNull(message="from date can not be null") LocalDate fromDate;
    @Column(name="to_date")
    @NotNull(message="to date can not be null")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private @NotNull(message="to date can not be null") LocalDate toDate;
    @Column(name="activity_ids", columnDefinition="jsonb")
    @JdbcTypeCode(value=3001)
    private List<String> activities;
    @Column(name="research_outputs", columnDefinition="jsonb")
    @JdbcTypeCode(value=3001)
    private List<String> results;
    @Column(name="projects", columnDefinition="jsonb")
    @JdbcTypeCode(value=3001)
    private List<String> projects;
    @Column(name="fundings", columnDefinition="jsonb")
    @JdbcTypeCode(value=3001)
    private List<String> fundings;

    public static TimePeriodBuilder builder() {
        return new TimePeriodBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public ResearcherProfile getResearcher() {
        return this.researcher;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public List<String> getActivities() {
        return this.activities;
    }

    public List<String> getResults() {
        return this.results;
    }

    public List<String> getProjects() {
        return this.projects;
    }

    public List<String> getFundings() {
        return this.fundings;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setResearcher(ResearcherProfile researcher) {
        this.researcher = researcher;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public void setActivities(List<String> activities) {
        this.activities = activities;
    }

    public void setResults(List<String> results) {
        this.results = results;
    }

    public void setProjects(List<String> projects) {
        this.projects = projects;
    }

    public void setFundings(List<String> fundings) {
        this.fundings = fundings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimePeriod)) {
            return false;
        }
        TimePeriod other = (TimePeriod)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        ResearcherProfile this$researcher = this.getResearcher();
        ResearcherProfile other$researcher = other.getResearcher();
        if (this$researcher == null ? other$researcher != null : !this$researcher.equals(other$researcher)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        LocalDate this$fromDate = this.getFromDate();
        LocalDate other$fromDate = other.getFromDate();
        if (this$fromDate == null ? other$fromDate != null : !((Object)this$fromDate).equals(other$fromDate)) {
            return false;
        }
        LocalDate this$toDate = this.getToDate();
        LocalDate other$toDate = other.getToDate();
        if (this$toDate == null ? other$toDate != null : !((Object)this$toDate).equals(other$toDate)) {
            return false;
        }
        List this$activities = this.getActivities();
        List other$activities = other.getActivities();
        if (this$activities == null ? other$activities != null : !((Object)this$activities).equals(other$activities)) {
            return false;
        }
        List this$results = this.getResults();
        List other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        List this$projects = this.getProjects();
        List other$projects = other.getProjects();
        if (this$projects == null ? other$projects != null : !((Object)this$projects).equals(other$projects)) {
            return false;
        }
        List this$fundings = this.getFundings();
        List other$fundings = other.getFundings();
        return !(this$fundings == null ? other$fundings != null : !((Object)this$fundings).equals(other$fundings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimePeriod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        ResearcherProfile $researcher = this.getResearcher();
        result = result * 59 + ($researcher == null ? 43 : $researcher.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        LocalDate $fromDate = this.getFromDate();
        result = result * 59 + ($fromDate == null ? 43 : ((Object)$fromDate).hashCode());
        LocalDate $toDate = this.getToDate();
        result = result * 59 + ($toDate == null ? 43 : ((Object)$toDate).hashCode());
        List $activities = this.getActivities();
        result = result * 59 + ($activities == null ? 43 : ((Object)$activities).hashCode());
        List $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        List $projects = this.getProjects();
        result = result * 59 + ($projects == null ? 43 : ((Object)$projects).hashCode());
        List $fundings = this.getFundings();
        result = result * 59 + ($fundings == null ? 43 : ((Object)$fundings).hashCode());
        return result;
    }

    public String toString() {
        return "TimePeriod(id=" + this.getId() + ", researcher=" + String.valueOf(this.getResearcher()) + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", fromDate=" + String.valueOf(this.getFromDate()) + ", toDate=" + String.valueOf(this.getToDate()) + ", activities=" + String.valueOf(this.getActivities()) + ", results=" + String.valueOf(this.getResults()) + ", projects=" + String.valueOf(this.getProjects()) + ", fundings=" + String.valueOf(this.getFundings()) + ")";
    }

    public TimePeriod() {
    }

    public TimePeriod(Long id, ResearcherProfile researcher, String title, String description, LocalDate fromDate, LocalDate toDate, List<String> activities, List<String> results, List<String> projects, List<String> fundings) {
        this.id = id;
        this.researcher = researcher;
        this.title = title;
        this.description = description;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.activities = activities;
        this.results = results;
        this.projects = projects;
        this.fundings = fundings;
    }
}

