/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.controller;

import eu.dnet.researcher.dto.ActivityDTO;
import eu.dnet.researcher.dto.CoAuthorDTO;
import eu.dnet.researcher.dto.FeaturedArticleDTO;
import eu.dnet.researcher.dto.FundingDTO;
import eu.dnet.researcher.dto.NetworkDTO;
import eu.dnet.researcher.dto.ResearcherEmailDTO;
import eu.dnet.researcher.dto.ResearcherPidDTO;
import eu.dnet.researcher.dto.ResearcherProfileDTO;
import eu.dnet.researcher.dto.TimePeriodDTO;
import eu.dnet.researcher.services.ActivityService;
import eu.dnet.researcher.services.FeaturedArticleService;
import eu.dnet.researcher.services.FundingService;
import eu.dnet.researcher.services.ImpactCategoryService;
import eu.dnet.researcher.services.ResearcherProfileService;
import eu.dnet.researcher.services.TimePeriodService;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.query.Param;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/researchers"})
public class ResearcherProfileController {
    @Autowired
    private ResearcherProfileService researcherProfileService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private FeaturedArticleService featuredArticleService;
    @Autowired
    private FundingService fundingService;
    @Autowired
    private ImpactCategoryService impactCategoryService;
    @Autowired
    private TimePeriodService timePeriodService;

    @PostMapping(value={"/init"})
    @PreAuthorize(value="@ProfileCheck.isSecurityEnabled() ? hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN) : true")
    public ResponseEntity<ResearcherProfileDTO> initUser(@RequestBody ResearcherProfileDTO researcherProfileDTO) {
        ResearcherProfileDTO savedResearcherProfileDTO = this.researcherProfileService.initProfile(researcherProfileDTO);
        this.impactCategoryService.initializeCategories(savedResearcherProfileDTO.getId());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)savedResearcherProfileDTO);
    }

    @PutMapping
    @PreAuthorize(value="@ProfileCheck.isSecurityEnabled() ? (hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN) || @ORCID.checkOrcidByResearcherId(#request.id)) : true")
    public ResponseEntity<ResearcherProfileDTO> partiallyUpdateProfile(@RequestBody @Valid ResearcherProfileDTO request) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.researcherProfileService.partiallyUpdateProfile(request));
    }

    @GetMapping(value={"/"})
    @PreAuthorize(value="@ProfileCheck.isSecurityEnabled() ? hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN) : true")
    public ResponseEntity<List<ResearcherProfileDTO>> getProfiles() {
        return ResponseEntity.ok((Object)this.researcherProfileService.getAllProfiles());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ResearcherProfileDTO> getProfile(Long id) {
        return ResponseEntity.ok((Object)this.researcherProfileService.getProfile(id));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteProfile(@PathVariable Integer id) {
        this.researcherProfileService.deleteProfile(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/orcid/{orcid}"})
    public ResponseEntity<ResearcherProfileDTO> getProfileByOrcid(@PathVariable String orcid) {
        return ResponseEntity.ok((Object)this.researcherProfileService.getProfileByOrcid(orcid));
    }

    @GetMapping(value={"/openaireId/{openaireId}"})
    public ResponseEntity<ResearcherProfileDTO> getProfileByOpenaire(@PathVariable String openaire) {
        return ResponseEntity.ok((Object)this.researcherProfileService.getProfileByOrcid(openaire));
    }

    @PutMapping(value={"/{id}/emails/save"})
    public ResponseEntity<ResearcherEmailDTO> addEmail(@PathVariable Long id, @Valid @RequestBody ResearcherEmailDTO researcherEmailDTO) {
        ResearcherEmailDTO savedEmail = this.researcherProfileService.saveEmail(id, researcherEmailDTO);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)savedEmail);
    }

    @DeleteMapping(value={"/emails/{emailId}"})
    public ResponseEntity<Void> deleteEmail(@PathVariable Long emailId) {
        this.researcherProfileService.deleteEmail(emailId);
        return ResponseEntity.noContent().build();
    }

    @PutMapping(value={"/{id}/pids/save"})
    public ResponseEntity<ResearcherPidDTO> addPid(@PathVariable Long id, @Valid @RequestBody ResearcherPidDTO researcherPidDTO) {
        ResearcherPidDTO savedProfile = this.researcherProfileService.savePid(id, researcherPidDTO);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)savedProfile);
    }

    @DeleteMapping(value={"/pids/{pidId}"})
    public ResponseEntity<Void> deletePid(@PathVariable Long pidId) {
        this.researcherProfileService.deletePid(pidId);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/fundings/{fundingId}"})
    public ResponseEntity<Void> deleteFunding(@PathVariable Long fundingId) {
        this.researcherProfileService.deleteFunding(fundingId);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/{id}/timeline"})
    public ResponseEntity<Void> deleteTimeline(@PathVariable Long id) {
        this.researcherProfileService.deleteTimeline(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/{id}/activities"})
    public ResponseEntity<List<ActivityDTO>> getAllActivities(@Param(value="activityConfiguration") @Nullable Long activityId, @PathVariable(value="id") Long researcherId, @Nullable @Param(value="fromYear") String from, @Nullable @Param(value="toYear") String to) {
        LocalDate fromDate = null;
        LocalDate toDate = null;
        if (from != null && to != null) {
            if (!from.matches("\\d{4}") || !to.matches("\\d{4}")) {
                throw new IllegalArgumentException("Invalid year format. Expected format: yyyy");
            }
            fromDate = LocalDate.of(Integer.parseInt(from), 1, 1);
            toDate = LocalDate.of(Integer.parseInt(to), 12, 31);
        }
        if (activityId == null) {
            return ResponseEntity.ok((Object)this.activityService.findByResearcherId(researcherId, fromDate, toDate));
        }
        return ResponseEntity.ok((Object)this.activityService.findByActivityIdAndResearcherId(activityId, researcherId, fromDate, toDate));
    }

    @GetMapping(value={"/{id}/fundings"})
    public ResponseEntity<List<FundingDTO>> getAllFundings(@PathVariable(value="id") Long researcherId, @Nullable @Param(value="fromYear") String from, @Nullable @Param(value="toYear") String to) {
        LocalDate fromDate = null;
        LocalDate toDate = null;
        if (from != null && to != null) {
            if (!from.matches("\\d{4}") || !to.matches("\\d{4}")) {
                throw new IllegalArgumentException("Invalid year format. Expected format: yyyy");
            }
            fromDate = LocalDate.of(Integer.parseInt(from), 1, 1);
            toDate = LocalDate.of(Integer.parseInt(to), 12, 31);
        }
        return ResponseEntity.ok((Object)this.fundingService.findByResearcherId(researcherId, fromDate, toDate));
    }

    @GetMapping(value={"/{id}/featuredArticles"})
    public ResponseEntity<List<FeaturedArticleDTO>> gallAllFeaturedArticles(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.featuredArticleService.getAllArticlesByResearcherId(id));
    }

    @GetMapping(value={"/{id}/timeline"})
    public ResponseEntity<List<TimePeriodDTO>> getallTimePeriods(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.timePeriodService.getAllTimePeriodsByResearcherId(id));
    }

    @GetMapping(value={"/coauthors"})
    ResponseEntity<List<CoAuthorDTO>> findCoAuthors(@RequestParam String orcid) {
        return ResponseEntity.ok((Object)this.researcherProfileService.findCoAuthors(orcid));
    }

    @GetMapping(value={"/years"})
    public ResponseEntity<List<Integer>> getAllYears(@RequestParam Long researcherId) {
        return ResponseEntity.ok((Object)this.researcherProfileService.getAllYears(researcherId));
    }

    @GetMapping(value={"/{id}/network"})
    public ResponseEntity<NetworkDTO> gwtNetwork(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.researcherProfileService.getNetwork(id));
    }
}

