/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.services;

import eu.dnet.researcher.dto.TimePeriodDTO;
import eu.dnet.researcher.mapper.TimePeriodMapper;
import eu.dnet.researcher.postgresql.ResearcherProfile;
import eu.dnet.researcher.postgresql.TimePeriod;
import eu.dnet.researcher.repositories.ResearcherProfileRepository;
import eu.dnet.researcher.repositories.TimePeriodRepository;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimePeriodService {
    @Autowired
    TimePeriodRepository timePeriodRepository;
    @Autowired
    ResearcherProfileRepository researcherProfileRepository;
    @Autowired
    TimePeriodMapper timePeriodMapper;

    public List<TimePeriodDTO> getAllTimePeriodsByResearcherId(Long researcherId) {
        return this.timePeriodRepository.findByResearcherId(researcherId).stream().map(arg_0 -> ((TimePeriodMapper)this.timePeriodMapper).toTimePeriodDto(arg_0)).toList();
    }

    public TimePeriodDTO getTimePeriodById(Long id) {
        return this.timePeriodRepository.findById((Object)id).map(arg_0 -> ((TimePeriodMapper)this.timePeriodMapper).toTimePeriodDto(arg_0)).orElseThrow(() -> new RuntimeException("Time period not found"));
    }

    public TimePeriodDTO save(TimePeriodDTO timePeriodDTO) {
        return this.saveTimePeriod(timePeriodDTO);
    }

    public TimePeriodDTO update(TimePeriodDTO timePeriodDTO) {
        return this.saveTimePeriod(timePeriodDTO);
    }

    public void delete(Long id) {
        this.timePeriodRepository.deleteById((Object)id);
    }

    private TimePeriodDTO saveTimePeriod(TimePeriodDTO timePeriodDTO) {
        Long researcherId = timePeriodDTO.getResearcherId();
        if (timePeriodDTO.getId() != null) {
            Optional entity = this.timePeriodRepository.findById((Object)timePeriodDTO.getId());
            if (entity.isEmpty()) {
                throw new EntityNotFoundException("You cannot update the timePeriod with id " + timePeriodDTO.getId() + ". It does not exist in DB");
            }
            if (!((TimePeriod)entity.get()).getResearcher().getId().equals(timePeriodDTO.getResearcherId())) {
                throw new IllegalArgumentException("You cannot update the time period with id " + timePeriodDTO.getId() + ". It does not match the researcher id " + timePeriodDTO.getResearcherId() + ".");
            }
        }
        ResearcherProfile researcherProfile = (ResearcherProfile)this.researcherProfileRepository.findById((Object)researcherId).orElseThrow(() -> new EntityNotFoundException("Researcher with id " + researcherId + " not found"));
        TimePeriod timePeriod = this.timePeriodMapper.toTimePeriod(timePeriodDTO);
        timePeriod.setResearcher(researcherProfile);
        this.timePeriodRepository.save((Object)timePeriod);
        return this.timePeriodMapper.toTimePeriodDto(timePeriod);
    }
}

