/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.controller;

import eu.dnet.researcher.dto.FundingDTO;
import eu.dnet.researcher.mapper.FundingMapper;
import eu.dnet.researcher.services.FundingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fundings"})
public class FundingController {
    @Autowired
    FundingService fundingService;
    @Autowired
    FundingMapper fundingMapper;

    @PostMapping(value={"/create"})
    @PreAuthorize(value="@ProfileCheck.isSecurityEnabled() ? (hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN) || @ORCID.checkOrcidByResearcherId(#fundingDTO.researcherId)) : true")
    public ResponseEntity<FundingDTO> createFunding(@RequestBody FundingDTO fundingDTO) {
        FundingDTO savedFunding = this.fundingService.save(fundingDTO);
        return ResponseEntity.ok((Object)savedFunding);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<FundingDTO> getFunding(@PathVariable Long id) {
        FundingDTO savedFunding = this.fundingService.findById(id);
        return ResponseEntity.ok((Object)savedFunding);
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="@ProfileCheck.isSecurityEnabled() ? (hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN) || @ORCID.checkOrcidByResearcherId(#fundingDTO.researcherId)) : true")
    public ResponseEntity<FundingDTO> updateFunding(@RequestBody FundingDTO fundingDTO) {
        if (fundingDTO.getId() == null) {
            throw new IllegalArgumentException("Funding has null id! You cannot update a profile without a valid id");
        }
        return ResponseEntity.ok((Object)this.fundingService.updateFunding(fundingDTO));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteFunding(@PathVariable Long id) {
        this.fundingService.deleteFunding(id);
        return ResponseEntity.noContent().build();
    }
}

