/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.controller;

import eu.dnet.researcher.dto.NetworkDTO;
import eu.dnet.researcher.dto.ResearcherProfileDTO;
import eu.dnet.researcher.services.NetworkService;
import eu.dnet.researcher.services.ResearcherProfileService;
import jakarta.persistence.EntityNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"network"})
public class NetworkController {
    @Autowired
    NetworkService networkService;
    @Autowired
    ResearcherProfileService researcherProfileService;

    @GetMapping
    public NetworkDTO getNetwork(Long id) {
        ResearcherProfileDTO researcher = this.researcherProfileService.getProfile(id);
        if (researcher.getNetworkJobId() == null) {
            throw new EntityNotFoundException("Not initialized network for user with id " + id);
        }
        return this.networkService.getNetwork(researcher.getNetworkJobId(), researcher.getOrcid());
    }

    @GetMapping(value={"orcid"})
    public NetworkDTO getNetworkByOrcid(String orcid) {
        ResearcherProfileDTO researcher = this.researcherProfileService.getProfileByOrcid(orcid);
        return this.networkService.getNetwork(researcher.getNetworkJobId(), researcher.getOrcid());
    }

    @PostMapping(value={"/create/orcid"})
    public String create(String orcid) {
        return this.networkService.createNetwork(orcid);
    }
}

