/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.exceptions;

import eu.dnet.researcher.exceptions.GlobalExceptionHandler;
import java.time.LocalDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;

public class GlobalExceptionHandler {
    private final Logger log = LogManager.getLogger(this.getClass());

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<ErrorResponse> handleRuntimeException(RuntimeException ex, WebRequest request) {
        ErrorResponse errorResponse = new ErrorResponse(this, "An error occurred: " + ex.getMessage() + String.valueOf(ex.getCause()), HttpStatus.INTERNAL_SERVER_ERROR.value(), LocalDateTime.now().toString());
        this.log.error((Object)ex);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<ErrorResponse> handleIllegalArgumentException(IllegalArgumentException ex) {
        ErrorResponse errorResponse = new ErrorResponse(this, ex.getMessage(), HttpStatus.BAD_REQUEST.value(), LocalDateTime.now().toString());
        this.log.error((Object)ex);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ErrorResponse> handleGlobalException(Exception ex) {
        ErrorResponse errorResponse = new ErrorResponse(this, "An error occurred: " + ex.getMessage() + String.valueOf(ex.getCause()), HttpStatus.INTERNAL_SERVER_ERROR.value(), LocalDateTime.now().toString());
        this.log.error((Object)ex);
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

