/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.services;

import eu.dnet.researcher.dto.NetworkDTO;
import eu.dnet.researcher.services.JobCreateResponse;
import eu.dnet.researcher.services.JobResponse;
import eu.dnet.researcher.services.NetworkServiceHelper;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

@Service
public class NetworkService {
    private static final Logger log = LogManager.getLogger(NetworkService.class);
    @Autowired
    @Qualifier(value="networkClient")
    private WebClient networkClient;

    public NetworkDTO getNetwork(String jobId, String orcid) {
        NetworkDTO networkDTO = null;
        Object json = this.networkClient.get().uri(uriBuilder -> uriBuilder.path("/process/result/network/{id}").build(new Object[]{orcid})).retrieve().onStatus(HttpStatusCode::isError, clientResponse -> clientResponse.bodyToMono(String.class).flatMap(errorMessage -> Mono.error((Throwable)new WebClientResponseException(clientResponse.statusCode().value(), "Error from Network Service", clientResponse.headers().asHttpHeaders(), errorMessage.getBytes(), null)))).bodyToMono(Object.class).block();
        if (json != null && !json.toString().isEmpty()) {
            networkDTO = NetworkDTO.builder().status("FINISHED").progress(1.0).errors(null).networkJson(json).build();
        } else {
            JobResponse jobResponse = (JobResponse)this.networkClient.get().uri(uriBuilder -> uriBuilder.path("/process/progress/{jobId}").build(new Object[]{jobId})).retrieve().onStatus(HttpStatusCode::isError, clientResponse -> clientResponse.bodyToMono(String.class).flatMap(errorMessage -> Mono.error((Throwable)new WebClientResponseException(clientResponse.statusCode().value(), "Error from Network Service", clientResponse.headers().asHttpHeaders(), errorMessage.getBytes(), null)))).bodyToMono(JobResponse.class).block();
            networkDTO = NetworkDTO.builder().status(jobResponse.status).progress(jobResponse.progress).errors(jobResponse.errors).networkJson(null).build();
        }
        return networkDTO;
    }

    public String createNetwork(String orcid) {
        NetworkServiceHelper requestBody = new NetworkServiceHelper();
        requestBody.setParameters(Map.of("orcid", orcid));
        log.info("Creating Network Service");
        JobCreateResponse jobResponse = (JobCreateResponse)((WebClient.RequestBodySpec)this.networkClient.post().uri("/process/start", new Object[0])).bodyValue((Object)requestBody).retrieve().bodyToMono(JobCreateResponse.class).doOnNext(response -> System.out.println("Response: " + String.valueOf(response))).block();
        log.info("After block... Network Service");
        return jobResponse.getJobId();
    }
}

