<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml" indent="yes" encoding="UTF-8"/>
    <xsl:template match="/">
        <result>
            <xsl:apply-templates select="row/groupresult"/>
        </result>
    </xsl:template>


    <xsl:template match="groupresult">
        <field>
            <xsl:attribute name='name'>
                <xsl:value-of select='./@field'/>
            </xsl:attribute>
            <xsl:attribute name='indexId'>
                <xsl:value-of select='./@field'/>
            </xsl:attribute>
            <field name="count">
                <xsl:attribute name="value">
                    <xsl:value-of select="./count"/>
                </xsl:attribute>
            </field>
            <field name="value">
                <xsl:choose>
                    <xsl:when test="./@field='funderid' or ./@field='fundinglevel0_id' or ./@field='fundinglevel1_id' or ./@field='fundinglevel2_id' or ./@field='relfunderid' or ./@field='relfundinglevel0_id' or ./@field='relfundinglevel1_id' or ./@field='relfundinglevel2_id'">
                        <xsl:attribute name="value">
                            <xsl:call-template name="getExtension">
						<xsl:with-param name="filename" select="./value"/>
                            </xsl:call-template>
                        </xsl:attribute>
                        <xsl:attribute name="value_original">
                            <xsl:value-of select="./value"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="value">
                            <xsl:value-of select="./value"/>
                        </xsl:attribute>
                        <xsl:attribute name="value_original">
                            <xsl:value-of select="./originalValue"/>
                        </xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
            </field>
        </field>
    </xsl:template>

    <xsl:template match="node() | @*"></xsl:template>

    <xsl:template name="getExtension">
        <xsl:param name="filename"/>
        <xsl:choose>
            <xsl:when test="contains($filename, '_::')">
                <xsl:call-template name="getExtension">
                    <xsl:with-param name="filename" select="substring-after($filename, '_::')"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$filename"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


</xsl:stylesheet>
