
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:oaf="http://namespace.openaire.eu/oaf"
                xmlns:dc="http://purl.org/dc/elements/1.1/">

    <!-- Turn off auto-insertion of <?xml> tag and set indenting on -->
    <xsl:output method="text" encoding="utf-8" omit-xml-declaration="yes" media-type="text/csv" />

    <!-- strip whitespace from whitespace-only nodes -->
    <xsl:strip-space elements="*"/>

    <xsl:template match = "/">
        <xsl:apply-templates select="//oaf:datasource"/>
    </xsl:template>

    <xsl:template match = "header">
        <xsl:text>"</xsl:text>
        <xsl:value-of select="dri:objIdentifier"/>
        <xsl:text>",</xsl:text>
    </xsl:template>

    <!-- Official Name, English name, Original Id -->
    <xsl:template match="oaf:datasource">
        <!-- Official Name -->
        <xsl:text>"</xsl:text>
        <xsl:value-of select="officialname"/>
        <xsl:text>",</xsl:text>

        <!--  English name  -->
        <xsl:text>"</xsl:text>
        <xsl:value-of select="englishname"/>
        <xsl:text>"</xsl:text>
        <xsl:text>,</xsl:text>

        <xsl:apply-templates select="//header"/>

        <!-- Original Id -->
        <xsl:text>"</xsl:text>
        <xsl:value-of select="originalId"/>
        <xsl:text>"</xsl:text>
        <xsl:text>&#xD;</xsl:text>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>

</xsl:stylesheet>
