
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:oaf="http://namespace.openaire.eu/oaf"
                xmlns:dc="http://purl.org/dc/elements/1.1/">

    <!-- Turn off auto-insertion of <?xml> tag and set indenting on -->
    <xsl:output method="text" encoding="utf-8" omit-xml-declaration="yes" media-type="text/csv" />

    <!-- strip whitespace from whitespace-only nodes -->
    <xsl:strip-space elements="*"/>

    <xsl:template match = "/">
        <xsl:apply-templates select="//oaf:organization"/>
    </xsl:template>

    <!-- Name, Projects, Country -->
    <xsl:template match="oaf:organization">

        <!-- Title -->
        <xsl:text>"</xsl:text>
        <xsl:value-of select="legalname"/>
        <xsl:text>",</xsl:text>

        <xsl:for-each select="rels/rel/to[@class='isParticipant']">
            <xsl:value-of select="../funding/funder/@shortname"/>
            <xsl:text>|</xsl:text>
            <xsl:value-of select="../acronym"/>
            <xsl:text>(</xsl:text>
            <xsl:value-of select="../code"/>
            <xsl:text>)</xsl:text>
            <xsl:if test="not(position()=last())">
                <xsl:text>;</xsl:text>
            </xsl:if>
        </xsl:for-each>
        <xsl:text>,</xsl:text>

        <xsl:value-of select="country/@classname"/>
         <xsl:text>&#xD;</xsl:text>
 <xsl:text>&#xA;</xsl:text>

    </xsl:template>

</xsl:stylesheet>