
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:oaf="http://namespace.openaire.eu/oaf"
                xmlns:dc="http://purl.org/dc/elements/1.1/">

    <!-- Turn off auto-insertion of <?xml> tag and set indenting on -->
    <xsl:output method="text" encoding="utf-8" omit-xml-declaration="yes" media-type="text/csv" />

    <!-- strip whitespace from whitespace-only nodes -->
    <xsl:strip-space elements="*"/>

    <xsl:template match = "/">
        <xsl:apply-templates select="//oaf:datasource"/>
    </xsl:template>

    <!-- Name, Type, Compatibility, OAI-PMH, website -->
    <xsl:template match="oaf:datasource">

        <!-- Name -->
        <xsl:text>"</xsl:text>
        <xsl:value-of select="officialname"/>
        <xsl:text>",</xsl:text>

        <!-- Type
        <xsl:value-of select="datasourcetype/@classname"/>
        <xsl:text>,</xsl:text>
        -->
        <!-- Compatibility
        <xsl:value-of select="openairecompatibility/@classname"/>
        <xsl:text>,</xsl:text>
        -->

        <!-- OAI-PMH
        <xsl:value-of select="accessinfopackage"/>
        <xsl:text>,</xsl:text>
        -->

        <!-- website -->
        <xsl:value-of select="websiteurl"/>
         <xsl:text>&#xD;</xsl:text>
 <xsl:text>&#xA;</xsl:text>

    </xsl:template>

</xsl:stylesheet>