<xsl:stylesheet xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
	xmlns:oaf="http://namespace.openaire.eu/oaf" exclude-result-prefixes="oaf"
	version="1.0">

	<xsl:output indent="yes" method="xml" omit-xml-declaration="yes" />
	<xsl:template match="//oaf:result">
		<oai_dc:dc xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
			<xsl:apply-templates />
		</oai_dc:dc>
	</xsl:template>
	<xsl:template match="subject">
		<dc:subject>
			<xsl:value-of select="." />
		</dc:subject>
	</xsl:template>
	<xsl:template match="oaf:result/publisher">
		<dc:publisher>
			<xsl:value-of select="." />
		</dc:publisher>
	</xsl:template>

	<!-- classname of instanceType for dataset is currently UNKNOWN and we want 
		to skip it -->
	<xsl:template
		match="oaf:result/resulttype | instanceType[./@classname!='Unknown'] | resourceType[./@classname != '']">
		<dc:type xml:lang="eng">
			<xsl:value-of select="./@classname" />
		</dc:type>
	</xsl:template>
	<xsl:template match="language[./@classid != '']">
		<dc:language>
			<xsl:value-of select="./@classid" />
		</dc:language>
	</xsl:template>
	<xsl:template match="description">
		<dc:description>
			<xsl:value-of select="." />
		</dc:description>
	</xsl:template>
	<xsl:template match="source | collectedFrom/@name">
		<dc:source>
			<xsl:value-of select="." />
		</dc:source>
	</xsl:template>
	<xsl:template match="oaf:result/title">
		<dc:title>
			<xsl:value-of select="." />
		</dc:title>
	</xsl:template>
	<xsl:template match="oaf:result/dateofacceptance">
		<dc:date>
			<xsl:value-of select="concat('date of acceptance: ', .)" />
		</dc:date>
	</xsl:template>
	<xsl:template match="oaf:result/embargoenddate">
		<dc:date>
			<xsl:value-of select="concat('end of embargo: ', .)" />
		</dc:date>
	</xsl:template>
	<xsl:template match="format">
		<dc:format>
			<xsl:value-of select="." />
		</dc:format>
	</xsl:template>
	<xsl:template match="originalId | pid">
		<dc:identifier>
			<xsl:value-of select="." />
		</dc:identifier>
	</xsl:template>
	<xsl:template match="bestaccessright">
		<dc:rights>
			<xsl:value-of select="./@classname" />
		</dc:rights>
	</xsl:template>
	<xsl:template match="rel[./to/@class='author']">
		<dc:creator>
			<xsl:value-of select="./fullname" />
		</dc:creator>
	</xsl:template>
	<xsl:template match="rel[./to/@class='contributor']">
		<dc:contributor>
			<xsl:value-of select="./fullname" />
		</dc:contributor>
	</xsl:template>
	<xsl:template match="rel[./to/@class='isResultOf']">
		<dc:relation>
			<xsl:value-of select="concat(./acronym, ', grant id: ', ./code)" />
		</dc:relation>
	</xsl:template>

	<!-- Links from dataset to publications: only title and openaire identifiers 
		are available...would be better to have the original id, or a pid... -->
	<xsl:template match="rel[/to/@class='isRelatedTo']">
		<dc:relation>
			<xsl:value-of select="./to" />
		</dc:relation>
		<dc:relation>
			<xsl:value-of select="./title" />
		</dc:relation>
	</xsl:template>
	<xsl:template match="context | category | concept">
		<dc:relation>
			<xsl:value-of select="./@label" />
		</dc:relation>
	</xsl:template>
	<xsl:template match="webresource/url">
		<dc:relation>
			<xsl:value-of select="." />
		</dc:relation>
	</xsl:template>


	<!-- Override default template -->
	<xsl:template match="text()|@*" />
</xsl:stylesheet>
