package eu.dnetlib.data.search.helpers.csv;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.util.List;

@JsonPropertyOrder({ "name", "type", "compatibility", "oaipmh", "websiteUrl" })
public class DatasourceCsv implements CsvEntity {

    @JsonProperty("Name")
    String name;
    @JsonProperty("Type")
    String type;
    @JsonProperty("Compatibility")
    String compatibility;
    @JsonProperty("OAI-PMH")
    List<String> oaipmh;
    @JsonProperty("Website")
    String websiteUrl;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCompatibility() {
        return compatibility;
    }

    public void setCompatibility(String compatibility) {
        this.compatibility = compatibility;
    }

    public List<String> getOaipmh() {
        return oaipmh;
    }

    public void setOaipmh(List<String> oaipmh) {
        this.oaipmh = oaipmh;
    }

    public String getWebsiteUrl() {
        return websiteUrl;
    }

    public void setWebsiteUrl(String websiteUrl) {
        this.websiteUrl = websiteUrl;
    }
}
