package eu.dnetlib.data.search.helpers.csv;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;

//Type	Title	Authors	Publication Year	DOI	Type	Peer Reviewed	Diamond Journal	Journal	Download from	Publicly Funded	Funder|Project Name (GA Number)	Access	Green	OA colour

@JsonPropertyOrder({"researchProduct", "title", "authors", "publicationYear", "doi", "type", "peerReviewed",
        "diamondJournal", "downloadFrom", "publiclyFunded", "funder_Project", "access", "green", "oaColour"})
public class ResearchProductCsv implements CsvEntity {

    @JsonProperty("Research Product Type")
    String researchProduct;
    @JsonProperty("Title")
    String title;
    @JsonProperty("Authors")
    List<String> authors;
    @JsonProperty("Publication Year")
    String publicationYear;
    @JsonProperty("DOI")
    List<String> doi;
    @JsonProperty("Type")
    String type;
    @JsonProperty("Peer Reviewed")
    String peerReviewed;
    @JsonProperty("Diamond Journal")
    boolean diamondJournal;
    @JsonProperty("Journal")
    String journal;
    @JsonProperty("Download From")
    String downloadFrom;
    @JsonProperty("Publicly Funded")
    boolean publiclyFunded;
    //TODO fix this
    @JsonProperty("Funder|Project Name (GA Number)")
    String funder_Project;
    @JsonProperty("Access")
    String access;
    @JsonProperty("Green")
    boolean green;
    @JsonProperty("OA colour")
    String oaColour;

    public String getResearchProduct() {
        return researchProduct;
    }

    public void setResearchProduct(String researchProduct) {
        this.researchProduct = researchProduct;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getAuthors() {
        return authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public String getPublicationYear() {
        return publicationYear;
    }

    public void setPublicationYear(String publicationYear) {
        this.publicationYear = publicationYear;
    }

    public List<String> getDoi() {
        return doi;
    }

    public void setDoi(List<String> doi) {
        this.doi = doi;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPeerReviewed() {
        return peerReviewed;
    }

    public void setPeerReviewed(String peerReviewed) {
        this.peerReviewed = peerReviewed;
    }

    public boolean isDiamondJournal() {
        return diamondJournal;
    }

    public void setDiamondJournal(boolean diamondJournal) {
        this.diamondJournal = diamondJournal;
    }

    public String getJournal() {
        return journal;
    }

    public void setJournal(String journal) {
        this.journal = journal;
    }

    public String getDownloadFrom() {
        return downloadFrom;
    }

    public void setDownloadFrom(String downloadFrom) {
        this.downloadFrom = downloadFrom;
    }

    public boolean isPubliclyFunded() {
        return publiclyFunded;
    }

    public void setPubliclyFunded(boolean publiclyFunded) {
        this.publiclyFunded = publiclyFunded;
    }

    public String getFunder_Project() {
        return funder_Project;
    }

    public void setFunder_Project(String funder_Project) {
        this.funder_Project = funder_Project;
    }

    public String getAccess() {
        return access;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public boolean isGreen() {
        return green;
    }

    public void setGreen(boolean green) {
        this.green = green;
    }

    public String getOaColour() {
        return oaColour;
    }

    public void setOaColour(String oaColour) {
        this.oaColour = oaColour;
    }
}
