package eu.dnetlib.data.search.mappers.csv;

import eu.dnetlib.data.search.helpers.csv.DatasourceCsv;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(componentModel = "spring")
public interface DatasourceCsvMapper {

    @Mapping(target="name", source = "datasource.officialname")
    @Mapping(target="type", source = "datasource.datasourcetype.label")
    @Mapping(target="compatibility", source = "datasource.openairecompatibility.label")
    @Mapping(target = "oaipmh", source = "datasource.accessinfopackage")
    @Mapping(target="websiteUrl", source="datasource.websiteurl")
    DatasourceCsv toDatasourceCsv(SolrRecord solrRecord);
}
