package eu.dnetlib.data.search.mappers.csv;

import eu.dnetlib.data.search.helpers.csv.OrganizationCsv;
import eu.dnetlib.dhp.schema.solr.Organization;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(componentModel = "spring")
public interface OrganizationCsvMapper {

    @Mapping(target="name", expression = "java(extractOrganizationName(solrRecord))")
    @Mapping(target="country", source="organization.country.label")
    OrganizationCsv toOrganizationCsv(SolrRecord solrRecord);

    default String extractOrganizationName(SolrRecord solrRecord) {
        if (solrRecord == null || solrRecord.getOrganization() == null) {
            return "";
        }

        StringBuilder organizationName = new StringBuilder();
        Organization organization = solrRecord.getOrganization();

        if (organization.getLegalname() != null) {
            organizationName.append(organization.getLegalname());
            if (organization.getLegalshortname() != null) {
                organizationName.append(" (").append(organization.getLegalshortname()).append(")");
            }
        } else if (organization.getLegalshortname() != null) {
            organizationName.append(organization.getLegalshortname());
        }

        return organizationName.toString();
    }

}
