package eu.dnetlib.data.search.micrometer;

import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import org.apache.log4j.Logger;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.ws.rs.core.Application;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;


@Configuration
@Component
public class Metrics {

    private static final Logger logger = Logger.getLogger(Metrics.class);

    private static final AtomicInteger n = new AtomicInteger(1);

    @Autowired
    private PrometheusMeterRegistry registry;

    @PostConstruct
    public void init() {

        new JvmMemoryMetrics().bindTo(registry);
        new JvmGcMetrics().bindTo(registry);
        new JvmThreadMetrics().bindTo(registry);
        new UptimeMetrics().bindTo(registry);

        Timer.builder("search.server.response.duration").description("search response time with solr request and transformation included")
                .sla(Duration.ofMillis(100), Duration.ofMillis(500), Duration.ofMillis(1000), Duration.ofMillis(2000), Duration.ofMillis(2500),
                        Duration.ofMillis(3000),Duration.ofMillis(4000), Duration.ofMillis(5000)).register(registry);

        Timer.builder("solr.server.response.duration").description("solr response time")
                .sla(Duration.ofMillis(100), Duration.ofMillis(500), Duration.ofMillis(1000), Duration.ofMillis(2000), Duration.ofMillis(2500),
                        Duration.ofMillis(3000),Duration.ofMillis(4000), Duration.ofMillis(5000)).register(registry);

        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = null;

        try {
                model = reader.read(
                        new InputStreamReader(
                                Application.class.getResourceAsStream(
                                        "/META-INF/maven/eu.dnetlib/uoa-search/pom.xml"
                                )
                        )
                );

        } catch (XmlPullParserException e) {
           logger.error("Error reading pom. ", e);

        } catch (IOException e) {
            logger.error("Error reading pom. ", e);
        } {

        }

        List<Dependency> list = model.getDependencies();
        Dependency micrometer = list.stream()
                .filter(dependency -> dependency.getArtifactId().equals("micrometer-registry-prometheus"))
                .findFirst()
                .get();

        registry.gauge("micrometer_info", Tags.of("component", model.getArtifactId()).and("scmtag", "HEAD").and("version", model.getVersion()), n);
        //registry.summary("search.server.response.size");

    }
}