package eu.dnetlib.data.search.solr;

import eu.dnetlib.api.data.IndexService;
import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.api.enabling.ISLookUpServiceException;
import gr.uoa.di.driver.util.ServiceLocator;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * Created by antleb on 2/4/14.
 */
public class SolrClientLocator implements ServiceLocator<IndexService> {
    private Logger logger = Logger.getLogger(getClass());

    private SolrIndexClient indexClient = null;
    private ServiceLocator<ISLookUpService> lookUpServiceServiceLocator = null;
    private String interpretation = null;

    private String cachedUrl = null;

    @Override
    public IndexService getService() {
        if (indexClient == null) {
            indexClient = locateIndexService();
        }

        return indexClient;
    }

    private SolrIndexClient locateIndexService() {
        SolrIndexClient client = new SolrIndexClient();

        try {
            List<String> urls = lookUpServiceServiceLocator.getService().quickSearchProfile("for $x in //RESOURCE_PROFILE//PROTOCOL[./@name='solr'] return data($x/@address)");

            if (urls.size() > 0) {
                logger.debug("cached url " + cachedUrl);
                cachedUrl = chooseIndexService(urls);

            } else {
                cachedUrl = getCachedIndexService(urls);
                logger.warn("Falling back to cached value for index : " + cachedUrl);
                throw new IllegalArgumentException("Could not locate an index service with a SOLR interface");
            }

        } catch (ISLookUpServiceException ise) {
            logger.warn("Error locating service", ise);

        } finally {
            logger.warn("Falling back to cached value for index : " + cachedUrl);
            client.setSolrServerUrl(cachedUrl);
            
            client.setInterpretation(this.interpretation);
        }

        return client;
    }

    private String getCachedIndexService(List<String> urls) {
        if (cachedUrl.equals("${services.index.default.url}"))
            return urls.get(0);
        return cachedUrl;
    }

    private String chooseIndexService(List<String> urls) {
        return urls.get(0);
    }


    public ServiceLocator<ISLookUpService> getLookUpServiceServiceLocator() {
        return lookUpServiceServiceLocator;
    }

    public void setLookUpServiceServiceLocator(ServiceLocator<ISLookUpService> lookUpServiceServiceLocator) {
        this.lookUpServiceServiceLocator = lookUpServiceServiceLocator;
    }

    public String getInterpretation() {
        return interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public String getCachedUrl() {
        return cachedUrl;
    }

    public void setCachedUrl(String cachedUrl) {
        this.cachedUrl = cachedUrl;
    }
}
