package eu.dnetlib.data.search.solr;

import eu.dnetlib.api.data.SearchServiceException;
import eu.dnetlib.data.search.helpers.csv.ResearchProductCsvConverter;
import eu.dnetlib.data.search.mappers.csv.DatasourceCsvMapper;
import eu.dnetlib.data.search.mappers.csv.OrganizationCsvMapper;
import eu.dnetlib.data.search.mappers.csv.ProjectCsvMapper;
import eu.dnetlib.data.search.mappers.csv.ResearchProductCsvMapper;
import eu.dnetlib.data.search.mappers.html.ResearchProductsHtmlMapper;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.SecureDriverResource;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.z3950.zing.cql.CQLParseException;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by antleb on 2/4/14.
 */
public class SolrResultSetFactory implements ResultSetFactory {

    private Logger logger = Logger.getLogger(getClass());
    //private Map<String, CloudSolrClient> clients = new HashMap<String, CloudSolrClient>();

    @Autowired
    private PrometheusMeterRegistry prometheusMeterRegistry;

    @Autowired
    DatasourceCsvMapper datasourceCsvMapper;

    @Autowired
    OrganizationCsvMapper organizationCsvMapper;

    @Autowired
    ProjectCsvMapper projectCsvMapper;

    @Autowired
    ResearchProductCsvMapper researchProductCsvMapper;

    @Autowired
    ResearchProductCsvConverter researchProductCsvConverter;

    @Autowired
    ResearchProductsHtmlMapper researchProductsHtmlMapper;


    private CloudSolrClient solrClient;
    private CloudSolrClient solrClientWithSocketTimeout;

    public void init(String[] zkservers, int socketTimeout) {
        logger.info("Initialization of clients.");

        logger.info("solrClient is set without socket timeout.");
        solrClient = new CloudSolrClient.Builder().withZkHost(Arrays.asList(zkservers)).build();
        if (socketTimeout!=-1) {
            logger.info("solrClientWithSocketTimeout is set with socket timeout " + socketTimeout );
            solrClientWithSocketTimeout = new CloudSolrClient.Builder().withZkHost(Arrays.asList(zkservers))
                    .withSocketTimeout(socketTimeout).build();
        } else {  //sudo solrClientWithSocketTimeout
            logger.info("solrClientWithSocketTimeout has ΝΟ actual timeout as the socketTimeout property is set to -1.");
            solrClientWithSocketTimeout = new CloudSolrClient.Builder().withZkHost(Arrays.asList(zkservers)).build();
        }

    }

    public ResultSet<String> createResultSetWithSocketTimeout(EPR epr) throws IOException, CQLParseException, SearchServiceException {
        logger.info("Get RS with solrClient With SocketTimeout for EPR: " + epr);
        return new SolrResultSet(epr, solrClientWithSocketTimeout, prometheusMeterRegistry, datasourceCsvMapper,
                organizationCsvMapper, projectCsvMapper, researchProductCsvMapper, researchProductCsvConverter, researchProductsHtmlMapper);
    }


    public ResultSet<String> createResultSetWithoutSocketTimeout(EPR epr) throws IOException, CQLParseException, SearchServiceException {
        logger.info("Get RS with solrClient Without SocketTimeout for EPR: " + epr);
        return new SolrResultSet(epr, solrClient, prometheusMeterRegistry, datasourceCsvMapper,
                organizationCsvMapper, projectCsvMapper, researchProductCsvMapper, researchProductCsvConverter, researchProductsHtmlMapper);

    }

    @Override
    public ResultSet<String> createResultSet(EPR epr) {
        logger.info("Get RS with solrClient Without SocketTimeout for EPR: " + epr);
        try {
            return new SolrResultSet(epr, solrClient, prometheusMeterRegistry, datasourceCsvMapper,
                    organizationCsvMapper, projectCsvMapper, researchProductCsvMapper, researchProductCsvConverter, researchProductsHtmlMapper);

        } catch (IOException ioe) {
            logger.error("Error in search. I will return null resultSet.", ioe);

        } catch (CQLParseException cqlpe) {
            logger.error("Error in cql parse. I will return null resultSet.", cqlpe);

        } catch (SearchServiceException sse) {
            logger.error("Error in search.", sse);
        }

        return null;

    }

    @Override
    public <D> ResultSet<D> createResultSet(EPR epr, Class<D> resourceClass) {
        return (ResultSet<D>) createResultSet(epr);
    }

    @Override
    public <D> ResultSet<D> createResultSet(ResultSet<?> rs, Class<D> resourceClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <D extends SecureDriverResource> ResultSet<D> createSecurityAwareRS(EPR epr, Class<D> resourceClass) {
        throw new UnsupportedOperationException();
    }
}
