package eu.dnetlib.data.search.transform;

import org.apache.log4j.Logger;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import java.io.StringReader;
import java.io.StringWriter;

public class XsltTransformer implements Transformer {
	
	private final String xslt;
	
	private final Logger logger = Logger.getLogger(XsltTransformer.class);
	private javax.xml.transform.Transformer xmlTransformer = null;
	private StringWriter xmlResultResource = new StringWriter();
	
	public XsltTransformer(String xslt) throws TransformerConfigurationException, TransformerFactoryConfigurationError {
		this.xslt = xslt;	
		
		//logger.debug(xslt);
		synchronized(this) {
			xmlTransformer = TransformerFactory.newInstance().newTemplates(new StreamSource(new StringReader(xslt))).newTransformer();
            xmlTransformer.setOutputProperty("encoding", "UTF-8");
		}
	}
	
	@Override
	public synchronized String transform(String input) throws TransformerException {
		//logger.debug("Transforming input: " + input);
		//logger.debug("xsl >>>>" + xslt);
		xmlResultResource.getBuffer().setLength(0);

		try {
			xmlTransformer.transform(new StreamSource(new StringReader(input)), new StreamResult(xmlResultResource));

		} catch (javax.xml.transform.TransformerException e) {
			logger.warn("Error transforming xml: " + input, e);
			throw new TransformerException("Error transforming xml: " + input, e);
		}

		return xmlResultResource.getBuffer().toString();
	}

	public String getXslt() {
		return xslt;
	}
	
}
