package eu.dnetlib.data.search.transform.config;

import eu.dnetlib.data.search.utils.vocabulary.Vocabulary;

import java.util.*;

public class Configuration {

	private String configurationName = null;
	
	//default locale
	private Locale defaultLocale = null;
	
	//supported locales
	private List<Locale> locales = new ArrayList<Locale>();
	
	//map of transformations per transformer: key-> transformer name, value-> list of all the transformations 
	private Map<String, List<Transformation>> transformationsMap = new HashMap<String, List<Transformation>>();
	
	//map of formatters: key name, value -> xslt
	private Map<String, FormatterConfiguration> formattersMap = new HashMap<String, FormatterConfiguration>();
	
	//contains the vocabularies that are created from index. key-> name, value-> vocabulary 
	private Map<String, Vocabulary> indexVocabularyMap = new HashMap<String, Vocabulary>();
	
	//contains the vocabularies that is loaded from IS. key-> name, value-> vocabulary 
	private Map<String, Vocabulary> isVocabularyMap = new HashMap<String, Vocabulary>();
	
	//contains the vocabularies that is loaded from classpath. key-> name, value-> vocabulary 
	private Map<String, Vocabulary> localVocabularyMap = new HashMap<String, Vocabulary>();
	
	public Configuration(String configurationName) {
		this.configurationName = configurationName;
	}
	
	public void setConfigurationName(String configurationName) {
		this.configurationName = configurationName;
	}

	public String getConfigurationName() {
		return configurationName;
	}

	public List<Locale> getLocales() {
		return locales;
	}

	public void setLocales(List<Locale> locales) {
		this.locales = locales;
	}

	public void setDefaultLocale(Locale defaultLocale) {
		this.defaultLocale = defaultLocale;
	}

	public Locale getDefaultLocale() {
		return defaultLocale;
	}

	public Map<String, List<Transformation>> getTransformationsMap() {
		return transformationsMap;
	}

	public void setTransformationsMap(
			Map<String, List<Transformation>> transformationsMap) {
		this.transformationsMap = transformationsMap;
	}

    public void setIndexVocabularyMap(Map<String, Vocabulary> indexVocabularyMap) {
		this.indexVocabularyMap = indexVocabularyMap;
	}

	public Map<String, Vocabulary> getIndexVocabularyMap() {
		return indexVocabularyMap;
	}

	public void setIsVocabularyMap(Map<String, Vocabulary> isVocabularyMap) {
		this.isVocabularyMap = isVocabularyMap;
	}

	public Map<String, Vocabulary> getIsVocabularyMap() {
		return isVocabularyMap;
	}

	public void setLocalVocabularyMap(Map<String, Vocabulary> localVocabularyMap) {
		this.localVocabularyMap = localVocabularyMap;
	}

	public Map<String, Vocabulary> getLocalVocabularyMap() {
		return localVocabularyMap;
	}

    public Map<String, FormatterConfiguration> getFormattersMap() {
        return formattersMap;
    }

    public void setFormattersMap(Map<String, FormatterConfiguration> formattersMap) {
        this.formattersMap = formattersMap;
    }
}
