package eu.dnetlib.data.search.transform.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class XPathTrasformation extends Transformation {
	private String change;
	private String vocabulary;
	private List<String> matches;

	public XPathTrasformation(String match, String change, String vocabulary) {
		this.change = change;
		this.vocabulary = vocabulary;
		this.matches = new ArrayList<String>(Arrays.asList(match.split("\\.")));
	}

	public List<String> getMatches() {
		return matches;
	}

	public String getChange() {
		return change;
	}

	public void setChange(String change) {
		this.change = change;
	}

	public String getVocabulary() {
		return vocabulary;
	}

	public void setVocabulary(String vocabulary) {
		this.vocabulary = vocabulary;
	}
}
