package eu.dnetlib.data.search.transform.formatter;

import eu.dnetlib.data.search.transform.FormatterException;
import eu.dnetlib.domain.data.SearchResult;
import org.apache.log4j.Logger;

import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import java.io.StringReader;
import java.io.StringWriter;

public class XSLTFormatter extends SimpleFormatter implements Formatter {

    private final String xslt;

    private final Logger logger = Logger.getLogger(XSLTFormatter.class);

    private javax.xml.transform.Transformer xmlTransformer = null;

    public XSLTFormatter(String xslt) throws FormatterException {
        super();
        this.xslt = xslt;
        try {
            synchronized(this){
                xmlTransformer = TransformerFactory.newInstance().newTemplates(new StreamSource(new StringReader(xslt))).newTransformer();
                xmlTransformer.setOutputProperty("encoding", "UTF-8");
            }
        } catch (TransformerException te) {
            logger.warn("Error creating "  + xslt + " transformer.", te);
        }
    }

    public XSLTFormatter(String xslt, String template) throws FormatterException {
        super(template);
        this.xslt = xslt;
        try {
            synchronized(this){
                xmlTransformer = TransformerFactory.newInstance().newTemplates(new StreamSource(new StringReader(xslt))).newTransformer();
                xmlTransformer.setOutputProperty("encoding", "UTF-8");
            }
        } catch (TransformerException te) {
            logger.warn("Error creating "  + xslt + " transformer.", te);
        }
    }

    public synchronized String format(SearchResult result)  throws FormatterException {
        String input = super.format(result);
        StringWriter xmlResultResource = new StringWriter();

        try {
            xmlTransformer.transform(new StreamSource(new StringReader(input)), new StreamResult(xmlResultResource));

        } catch (TransformerException te) {
            logger.warn("Error transforming xml: " + input, te);
            throw new FormatterException("Error transforming xml: " + input, te);
        }

        //logger.debug("Transformer returns " + xmlResultResource.toString());
        return xmlResultResource.toString();
    }

    public String getXslt() {
        return xslt;
    }

}
