package eu.dnetlib.data.search.transform.utils;

import org.apache.log4j.Logger;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

/**
 * Created by antleb on 12/12/13.
 */
public class VelocityUtil {
    private static VelocityEngine ve = null;

    private static Logger logger = Logger.getLogger(VelocityUtil.class);

    public synchronized static VelocityEngine getEngine() {
        if (ve == null) {
            try {
                ve = new VelocityEngine();
                ve.setProperty(RuntimeConstants.RESOURCE_LOADER, "classpath");
                ve.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
                ve.setProperty(RuntimeConstants.RUNTIME_LOG_LOGSYSTEM_CLASS, "org.apache.velocity.runtime.log.Log4JLogChute");
                ve.setProperty("runtime.log.logsystem.log4j.logger", "root");

                ve.init();
            } catch (Exception e) {
                logger.error("Error initializing velocity", e);
                ve = null;
            }
        }

        return ve;
    }
}