package eu.dnetlib.data.search.utils.solr;


import eu.dnetlib.api.data.SearchServiceException;
import eu.dnetlib.functionality.cql.CqlTranslator;
import eu.dnetlib.functionality.cql.CqlTranslatorImpl;
import eu.dnetlib.functionality.cql.lucene.TranslatedQuery;
import org.apache.log4j.Logger;
import org.apache.solr.common.util.NamedList;
import org.z3950.zing.cql.CQLParseException;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;

/**
 * Created by kiatrop on 21/11/2016.
 */
public class SolrResultSetOptionsUtil {

    private static final Logger logger = Logger.getLogger(SolrResultSetOptionsUtil.class);

    public static NamedList<String> extractQueryOptions(String eprQuery) throws CQLParseException, IOException, SearchServiceException {
        //System.out.println("EPR Query on extract: " + eprQuery);
        CqlTranslator translator = new CqlTranslatorImpl();
        NamedList<String> queryOpts = new NamedList<String>();

        String query = null;
        boolean refineSummary = false; //to be backwards compatible
        String[] sortParts = eprQuery.split("&sort=");
        String[] refineSummaryMode = sortParts[0].split("&minRef=");
        String[] queryParts = eprQuery.split("&groupby=");

        if (refineSummaryMode!=null) {
            if (refineSummaryMode.length > 1 && refineSummaryMode[1].equals("true")) {
                refineSummary = true;
            }
            query = refineSummaryMode[0].replace("query=","");
        }

        TranslatedQuery translatedQuery = null;

        try {
            translatedQuery = translator.getTranslatedQuery(query);
        } catch (RuntimeException re) {
            throw new SearchServiceException("Malformed Query " + query +". " + re.getMessage());
        }
       // logger.info("QUERY ... " + translatedQuery);
        queryOpts.add("q", translatedQuery.asLucene());
       // queryOpts.add("fl", "__result");
        queryOpts.add("shards.tolerant","true");


        if (sortParts!=null && sortParts.length > 1) {
            for(String sortP:sortParts) {
                //System.out.println("sort parts " + sortP);
            }
            if(sortParts[1]!=null) {
                int end = sortParts[1].indexOf("&groupby");

                //System.out.println("start: " + 0 + "end:" + end);
                String sortOption = sortParts[1].substring(0, end);
                //System.out.println("sortOption " + sortOption);
                if (sortOption != null && sortOption.length() > 1) {
                    String[] sortPhrases = sortOption.split(",");
                        if (sortPhrases != null && sortPhrases.length > 0) {
                            //System.out.println("sortphrases " + sortPhrases.length);
                            //System.out.println("sortPhrases[1]" + sortPhrases[0]);
                            StringBuilder sortPart = new StringBuilder();
                            for (String sortPhrase : sortPhrases) {
                                String[] sortMembers = sortPhrase.split("/");
                                if(!sortPart.toString().isEmpty()){
                                    sortPart.append(", ");
                                }
                                if (sortMembers != null) {
                                    //System.out.println("sortMembers[1]: " + sortMembers[1]);
                                    if (sortMembers[1].equals("sort.ascending")) {
                                        sortPart.append(sortMembers[0].trim() + " asc");
                                    } else if (sortMembers[1].equals("sort.descending")) {
                                        sortPart.append(sortMembers[0].trim() + " desc");
                                    }
                                }
                            }
                            queryOpts.add("sort", sortPart.toString());
                        }
                    }
                }
            }



        if (queryParts.length > 1) {

            //facetParts groupby + sf
            String[] facetParts = queryParts[1].split("&fq=");

            logger.debug("facet parts" + Arrays.asList(facetParts));

            String[] refineParts = null;
            String[] refineFields = null;
            String[] specialFacets = null;
            String[] facetQueries = null;

            if (facetParts != null && facetParts.length > 0) {
                if (!facetParts[0].isEmpty()) {
                    refineParts = facetParts[0].split("&sf=");
                    logger.debug("refine parts " + Arrays.asList(refineParts));

                    if (refineParts != null && refineParts.length > 0) {
                        refineFields = refineParts[0].split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                    }

                    if(refineParts.length > 1){
                        refineParts[1].replace("&sf=","");
                        specialFacets = refineParts[1].split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                    }
                }

                if (facetParts.length > 1){
                    facetQueries = facetParts[1].split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                }

            }


/*            logger.debug("refine fields " + Arrays.asList(refineFields));
            logger.debug("special facets " + Arrays.asList(specialFacets));
            logger.debug("facet queries " + Arrays.asList(facetParts));*/

            if (refineFields != null && refineFields.length > 0) {
                queryOpts.add("facet", "true");
                queryOpts.add("facet.mincount", "1");
                queryOpts.add("facet.threads", refineFields.length + "");
                for (String field : refineFields) {
                    queryOpts.add("facet.field", field);

                    if( (specialFacets == null || specialFacets.length == 0) ||
                            (specialFacets != null && !Arrays.asList(specialFacets).contains(field))) {
                        queryOpts.add("f." + field + ".facet.limit", refineSummary?"7":"100");
                    }
                }
            }

            if (specialFacets != null && specialFacets.length > 0) {
                for (String field : specialFacets) {
                    queryOpts.add("f."+field+".facet.limit", "-1");
                }
            }
            

            if (facetQueries!=null && facetQueries.length > 0) {
                //queryOpts.add("q.op", "AND"); TODO is it correct?

                for (String facetPart : facetQueries) {
                    logger.debug("facet Part " + facetPart);
                    queryOpts.add("fq", translator.toLucene(facetPart));
                }
            }

        }

        return queryOpts;
    }
}
