package eu.dnetlib.data.search.utils.vocabulary;

import eu.dnetlib.api.data.SearchService;
import eu.dnetlib.api.data.SearchServiceException;
import eu.dnetlib.domain.data.FormattedSearchResult;
import gr.uoa.di.driver.util.ServiceLocator;
import gr.uoa.di.driver.xml.VocabularyXmlConverter;
import org.apache.log4j.Logger;

import javax.xml.bind.JAXBException;
import java.util.Locale;

/**
 * Loads vocabulary that is created after a search query. 
 * The vocabulary is created based on the {@link Vocabulary}} transformer. 
 * @author kiatrop
 *
 */
public class IndexVocabularyLoader extends VocabularyLoader {
	private ServiceLocator<SearchService> searchServiceLocator = null;
	
	//in the case of IS vocabs, the only locale is the default
	//private String localeCountry = null;
	//private String localeLanguage = null;
	
	//the default number of the results in search request (same as result set)
	private static final int REQUEST_SIZE = 100;

	private Logger logger = Logger.getLogger(IndexVocabularyLoader.class);

	public String getVocabularyXml(Vocabulary vocabulary, Locale locale) {
		logger.debug("Getting vocabulary with name " + vocabulary.getName() + " and locale " + locale);

		String xml = null;
		FormattedSearchResult fsr = null;

		//long time = System.currentTimeMillis();
		//String stringLocale = locale.getLanguage() + "_" + locale.getCountry();

		try {
			fsr = searchServiceLocator.getService().search(
					((IndexVocabulary)vocabulary).getQuery(),
					((IndexVocabulary)vocabulary).getTransformer(),
					"vocabulary", null, 1, REQUEST_SIZE);

			if (fsr !=null) {
				int totalResultNumber = fsr.getResultsNumber();

				//make sure that every result is loaded
				if (totalResultNumber > REQUEST_SIZE) {

					if (fsr != null) {
						fsr = searchServiceLocator.getService().search(
								((IndexVocabulary) vocabulary).getQuery(),
								((IndexVocabulary) vocabulary).getTransformer(),
								"vocabulary", null, 1, totalResultNumber);
					}

					xml = fsr.getFormattedResult();
				}
			}

		} catch (SearchServiceException sse) {
			logger.error("Error getting Vocabulary xml", sse);
		}

		//time = System.currentTimeMillis() - time;
		//System.out.println("old Vocabulary creation took " + time);


		return xml;
	}

	public ServiceLocator<SearchService> getSearchServiceLocator() {
		return searchServiceLocator;
	}

	public void setSearchServiceLocator(
			ServiceLocator<SearchService> searchServiceLocator) {
		this.searchServiceLocator = searchServiceLocator;
	}

	@Override
	protected eu.dnetlib.domain.enabling.Vocabulary getVocabulary(Vocabulary vocabulary, Locale locale) {

		String xml = getVocabularyXml(vocabulary, locale);
		VocabularyXmlConverter converter = null;
		try {
			converter = new VocabularyXmlConverter();
			return converter.XmlToObject(xml);

		} catch (JAXBException jaxbe) {
			logger.error("Fail to create vocabulary " + vocabulary.getName(), jaxbe);
			return null;
		}
	}
}
 