package eu.dnetlib.data.search.web.api;

import eu.dnetlib.data.search.web.utils.RequestResponseHandler;
import org.apache.log4j.Logger;

/**
 * Created by kiatrop on 20/12/2016.
 */
public class CSVResponseFormat {

    public static final String organization = "Name,Projects,Country\r\n";
    public static final String datasource = "Name,Type,Compatibility,OAI-PMH,website\r\n";
    public static final String service = "Name,website\r\n";
    public static final String person = "Fullname\r\n";
    public static final String project = "Title,Funder,Start Date,End Date,Participants\r\n";
    //    public static final String result = "Type,Title,Authors,Publication Year,DOI,Green,OA colour,Download from,Type,Diamond,Journal,Publicly Funded,Funder|Project Name (GA Number),Access\r\n";
    public static final String result = "Type,Title,Authors,Publication Year,DOI,Type,Peer Reviewed,Diamond Journal,Journal,Download from,Publicly Funded,Funder|Project Name (GA Number),Access,Green,OA colour\r\n";

    //TODO SPECIAL
    public static final String result_special = "Type,Title,Authors,Publication Year,DOI,Type,Peer Reviewed,Diamond Journal,Journal,Download from,Publicly Funded,Funder,Project Name (GA Number),Access,Green,OA colour\r\n";

    private static Logger logger = Logger.getLogger(CSVResponseFormat.class);


    public static final String response = "%s%s";

    public static String appendTitle(RequestResponseHandler.Entity entity, boolean special) {
        if(entity.equals(RequestResponseHandler.Entity.ORGANIZATION)) {
            return  organization;

        } else if (entity.equals(RequestResponseHandler.Entity.DATASOURCE)) {
            return  datasource;

        } else if (entity.equals(RequestResponseHandler.Entity.SERVICE)) {
            return service;
        }
        /* else if (entity.equals(RequestResponseHandler.Entity.PERSON)) {
            return  person;

        }*/ else if (entity.equals(RequestResponseHandler.Entity.PROJECT)) {
            return project;

        } else if (entity.equals(RequestResponseHandler.Entity.PUBLICATION) || entity.equals(RequestResponseHandler.Entity.DATASET)
                    ||entity.equals(RequestResponseHandler.Entity.SOFTWARE) || entity.equals(RequestResponseHandler.Entity.OTHER)
                    || entity.equals(RequestResponseHandler.Entity.RESULT)) {

            if (special) {
                return result_special;
            }

            return result;
        }

        return "";
    }



}
