<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:oaf="http://namespace.openaire.eu/oaf"
                xmlns:dc="http://purl.org/dc/elements/1.1/">

    <!-- Turn off auto-insertion of <?xml> tag and set indenting on -->
    <xsl:output method="text" encoding="utf-8" omit-xml-declaration="yes" media-type="text/csv" />

    <!-- strip whitespace from whitespace-only nodes -->
    <xsl:strip-space elements="*"/>

    <xsl:template match = "/">
        <xsl:text disable-output-escaping="yes">Project title,Project Acronym,Project ID,Funder,Funding Stream,Funding Substream level 1,Funding Substream level 2,SC39,Start Date,End Date&#xD;</xsl:text>
        <xsl:apply-templates select="//oaf:project"/>
    </xsl:template>

    <!-- Project title, Project Acronym, Project ID, Funder, Funding Stream, Funding Substream level 1, Funding Substream level 2, SC39, Start Date, End Date -->
    <xsl:template match="//oaf:project">

        <xsl:for-each select="fundingtree">
            <!-- Project title -->
            <xsl:text>&quot;</xsl:text>
            <xsl:value-of select="../title"/>
            <xsl:text>&quot;</xsl:text>
            <xsl:text>,</xsl:text>

            <!-- Project Acronym -->
            <xsl:text>&quot;</xsl:text>
            <xsl:value-of select="../acronym"/>
            <xsl:text>&quot;</xsl:text>
            <xsl:text>,</xsl:text>

            <!-- Project ID -->
            <xsl:text>&quot;</xsl:text>
            <xsl:value-of select="../code"/>
            <xsl:text>&quot;</xsl:text>
            <xsl:text>,</xsl:text>

            <!-- Funder -->
            <!--<xsl:for-each select="funder">-->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="funder/shortname"/>
                <xsl:text>&quot;</xsl:text>
            <!--</xsl:for-each>-->
            <xsl:text>,</xsl:text>

            <!-- Funding Stream-->
            <!--<xsl:for-each select="funding_level_2/parent/funding_level_1/parent/funding_level_0">-->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select=".//funding_level_0/name"/>
                <xsl:text>&quot;</xsl:text>
            <!--</xsl:for-each>-->
            <xsl:text>,</xsl:text>

            <!-- Funding Substream Level 1 -->
            <!--<xsl:for-each select="funding_level_2/parent/funding_level_1">-->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select=".//funding_level_1/name"/>
                <xsl:text>&quot;</xsl:text>
            <!--</xsl:for-each>-->
            <xsl:text>,</xsl:text>

            <!-- Funding Substream Level 2 -->
            <!--<xsl:for-each select="funding_level_2">-->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select=".//funding_level_2/name"/>
                <xsl:text>&quot;</xsl:text>
            <!--</xsl:for-each>-->
            <xsl:text>,</xsl:text>


            <!-- SC39 -->
            <xsl:text>&quot;</xsl:text>
            <xsl:value-of select="../ecsc39"/>
            <xsl:text>&quot;</xsl:text>
            <xsl:text>,</xsl:text>

            <!-- Start Date -->
            <xsl:text>&quot;</xsl:text>
            <xsl:value-of select="../startdate"/>
            <xsl:text>&quot;</xsl:text>
            <xsl:text>,</xsl:text>

            <!-- End Date -->
            <xsl:text>&quot;</xsl:text>
            <xsl:value-of select="../enddate"/>
            <xsl:text>&quot;</xsl:text>
             <xsl:text>&#xD;</xsl:text>
 <xsl:text>&#xA;</xsl:text>
            </xsl:for-each>

    </xsl:template>

</xsl:stylesheet>