/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.app;

import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.api.enabling.ISRegistryService;
import eu.dnetlib.data.search.app.SearchServiceImpl;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import gr.uoa.di.driver.util.ServiceLocator;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SearchServiceBlackboardHandler
extends BlackboardNotificationHandler<BlackboardServerHandler> {
    private static Logger logger = Logger.getLogger(SearchServiceBlackboardHandler.class);
    private SearchServiceImpl searchService = null;
    private ServiceLocator<ISLookUpService> lookUpServiceServiceLocator = null;
    private ServiceLocator<ISRegistryService> registryServiceServiceLocator = null;
    private XPathExpression indexMdFormatExpression = null;
    private XPathExpression indexLayoutExpression = null;
    private XPathExpression searchMdFormatExpression = null;

    public SearchServiceBlackboardHandler() throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        this.indexMdFormatExpression = xpath.compile("//METADATA_FORMAT");
        this.indexLayoutExpression = xpath.compile("//METADATA_FORMAT_LAYOUT");
        this.searchMdFormatExpression = xpath.compile("//SERVICE_PROPERTIES/PROPERTY[@key='mdformat']");
    }

    protected void processJob(BlackboardJob job) {
        logger.info((Object)"Got Blackboard Message");
        String action = job.getAction();
        try {
            ((BlackboardServerHandler)this.getBlackboardHandler()).ongoing(job);
            if (!action.equals("UpdateIndex")) {
                throw new Exception("Don't know what to do with " + action);
            }
            String indexProfileId = (String)job.getParameters().get("IndexId");
            logger.info((Object)("Updating the service to use index " + indexProfileId));
            String indexProfile = ((ISLookUpService)this.lookUpServiceServiceLocator.getService()).getResourceProfile(indexProfileId);
            String mdFormat = this.getMDFormat(indexProfile);
            String indexLayout = this.getIndexLayout(indexProfile);
            logger.info((Object)("New mdFormat: " + mdFormat + ", new layout: " + indexLayout));
            this.searchService.setMdFormat(mdFormat);
            this.searchService.setIndexLayout(indexLayout);
            String searchProfileId = this.searchService.getServiceEPR().getParameter("serviceId");
            this.updateSearchServiceProfile(searchProfileId, mdFormat);
            ((BlackboardServerHandler)this.getBlackboardHandler()).done(job);
        }
        catch (Exception e) {
            ((BlackboardServerHandler)this.getBlackboardHandler()).failed(job, (Throwable)e);
            logger.error((Object)"Error processing job", (Throwable)e);
        }
    }

    private String getIndexLayout(String indexProfile) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(indexProfile)));
        Node layoutNode = (Node)this.indexLayoutExpression.evaluate(doc, XPathConstants.NODE);
        return layoutNode.getTextContent();
    }

    private String getMDFormat(String indexProfile) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(indexProfile)));
        Node layoutNode = (Node)this.indexMdFormatExpression.evaluate(doc, XPathConstants.NODE);
        return layoutNode.getTextContent();
    }

    private void updateSearchServiceProfile(String searchProfileId, String mdFormat) {
        try {
            String searchProfile = ((ISLookUpService)this.lookUpServiceServiceLocator.getService()).getResourceProfile(searchProfileId);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(searchProfile)));
            Node node = (Node)this.searchMdFormatExpression.evaluate(doc, XPathConstants.NODE);
            node.getAttributes().getNamedItem("value").setNodeValue(mdFormat);
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            ((ISRegistryService)this.registryServiceServiceLocator.getService()).updateProfile(searchProfileId, writer.toString(), "SearchServiceResourceType");
        }
        catch (Exception e) {
            logger.error((Object)("Fail to update search service profile with id " + searchProfileId), (Throwable)e);
        }
        logger.info((Object)("Updated search service profile with id " + searchProfileId));
    }

    public ServiceLocator<ISLookUpService> getLookUpServiceServiceLocator() {
        return this.lookUpServiceServiceLocator;
    }

    public void setLookUpServiceServiceLocator(ServiceLocator<ISLookUpService> lookUpServiceServiceLocator) {
        this.lookUpServiceServiceLocator = lookUpServiceServiceLocator;
    }

    public void setRegistryServiceServiceLocator(ServiceLocator<ISRegistryService> registryServiceServiceLocator) {
        this.registryServiceServiceLocator = registryServiceServiceLocator;
    }

    public SearchServiceImpl getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchServiceImpl searchService) {
        this.searchService = searchService;
    }
}

