/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.helpers.csv;

import eu.dnetlib.data.search.helpers.csv.ResearchProductCsv;
import eu.dnetlib.data.search.mappers.csv.ResearchProductCsvMapper;
import eu.dnetlib.dhp.schema.solr.RelatedRecord;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResearchProductCsvConverter {
    @Autowired
    ResearchProductCsvMapper researchProductCsvMapper;

    public List<ResearchProductCsv> flattenProjects(SolrRecord solrRecord) {
        ArrayList<ResearchProductCsv> flattenedList = new ArrayList<ResearchProductCsv>();
        if (solrRecord.getLinks() != null) {
            boolean hasProducedRecord = false;
            for (RelatedRecord relatedRecord : solrRecord.getLinks()) {
                if (!this.isProducedByRelation(relatedRecord)) continue;
                ResearchProductCsv newProduct = this.mapToResearchProductWithFunder(solrRecord, relatedRecord);
                flattenedList.add(newProduct);
                hasProducedRecord = true;
            }
            if (!hasProducedRecord) {
                ResearchProductCsv defaultProduct = this.researchProductCsvMapper.toResearchProductCsv(solrRecord);
                flattenedList.add(defaultProduct);
            }
        }
        return flattenedList;
    }

    private boolean isProducedByRelation(RelatedRecord relatedRecord) {
        return relatedRecord.getHeader() != null && "isProducedBy".equalsIgnoreCase(relatedRecord.getHeader().getRelationClass());
    }

    private ResearchProductCsv mapToResearchProductWithFunder(SolrRecord solrRecord, RelatedRecord relatedRecord) {
        ResearchProductCsv newProduct = this.researchProductCsvMapper.toSimpleResearchProductCsv(solrRecord);
        String funderString = Optional.ofNullable(relatedRecord.getFunding()).map(funding -> Optional.ofNullable(funding.getFunder()).map(funder -> Optional.ofNullable(funder.getShortname()).orElse(funder.getName())).orElse("")).orElse("");
        String projectString = Optional.ofNullable(relatedRecord.getAcronym()).orElseGet(() -> Optional.ofNullable(relatedRecord.getProjectTitle()).orElse("Unknown"));
        String funderProject = funderString + "|" + projectString;
        String code = Optional.ofNullable(relatedRecord.getCode()).filter(c -> !"unidentified".equalsIgnoreCase((String)c)).map(c -> "(" + c + ")").orElse("");
        newProduct.setFunder_Project(funderProject + code);
        return newProduct;
    }
}

