/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.mappers.csv;

import eu.dnetlib.data.search.helpers.csv.DatasourceCsv;
import eu.dnetlib.data.search.mappers.csv.DatasourceCsvMapper;
import eu.dnetlib.dhp.schema.solr.CodeLabel;
import eu.dnetlib.dhp.schema.solr.Datasource;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DatasourceCsvMapperImpl
implements DatasourceCsvMapper {
    @Override
    public DatasourceCsv toDatasourceCsv(SolrRecord solrRecord) {
        List<String> accessinfopackage;
        if (solrRecord == null) {
            return null;
        }
        DatasourceCsv datasourceCsv = new DatasourceCsv();
        datasourceCsv.setName(this.solrRecordDatasourceOfficialname(solrRecord));
        datasourceCsv.setType(this.solrRecordDatasourceDatasourcetypeLabel(solrRecord));
        datasourceCsv.setCompatibility(this.solrRecordDatasourceOpenairecompatibilityLabel(solrRecord));
        List<String> list = accessinfopackage = this.solrRecordDatasourceAccessinfopackage(solrRecord);
        if (list != null) {
            datasourceCsv.setOaipmh(new ArrayList<String>(list));
        }
        datasourceCsv.setWebsiteUrl(this.solrRecordDatasourceWebsiteurl(solrRecord));
        return datasourceCsv;
    }

    private String solrRecordDatasourceOfficialname(SolrRecord solrRecord) {
        if (solrRecord == null) {
            return null;
        }
        Datasource datasource = solrRecord.getDatasource();
        if (datasource == null) {
            return null;
        }
        String officialname = datasource.getOfficialname();
        if (officialname == null) {
            return null;
        }
        return officialname;
    }

    private String solrRecordDatasourceDatasourcetypeLabel(SolrRecord solrRecord) {
        if (solrRecord == null) {
            return null;
        }
        Datasource datasource = solrRecord.getDatasource();
        if (datasource == null) {
            return null;
        }
        CodeLabel datasourcetype = datasource.getDatasourcetype();
        if (datasourcetype == null) {
            return null;
        }
        String label = datasourcetype.getLabel();
        if (label == null) {
            return null;
        }
        return label;
    }

    private String solrRecordDatasourceOpenairecompatibilityLabel(SolrRecord solrRecord) {
        if (solrRecord == null) {
            return null;
        }
        Datasource datasource = solrRecord.getDatasource();
        if (datasource == null) {
            return null;
        }
        CodeLabel openairecompatibility = datasource.getOpenairecompatibility();
        if (openairecompatibility == null) {
            return null;
        }
        String label = openairecompatibility.getLabel();
        if (label == null) {
            return null;
        }
        return label;
    }

    private List<String> solrRecordDatasourceAccessinfopackage(SolrRecord solrRecord) {
        if (solrRecord == null) {
            return null;
        }
        Datasource datasource = solrRecord.getDatasource();
        if (datasource == null) {
            return null;
        }
        List accessinfopackage = datasource.getAccessinfopackage();
        if (accessinfopackage == null) {
            return null;
        }
        return accessinfopackage;
    }

    private String solrRecordDatasourceWebsiteurl(SolrRecord solrRecord) {
        if (solrRecord == null) {
            return null;
        }
        Datasource datasource = solrRecord.getDatasource();
        if (datasource == null) {
            return null;
        }
        String websiteurl = datasource.getWebsiteurl();
        if (websiteurl == null) {
            return null;
        }
        return websiteurl;
    }
}

