/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.mappers.csv;

import eu.dnetlib.data.search.helpers.csv.ProjectCsv;
import eu.dnetlib.data.search.mappers.csv.ProjectCsvMapper;
import eu.dnetlib.dhp.schema.solr.Project;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import org.springframework.stereotype.Component;

@Component
public class ProjectCsvMapperImpl
implements ProjectCsvMapper {
    @Override
    public ProjectCsv toProjectCsv(SolrRecord solrRecord) {
        if (solrRecord == null) {
            return null;
        }
        ProjectCsv projectCsv = new ProjectCsv();
        projectCsv.setTitle(this.solrRecordProjectTitle(solrRecord));
        projectCsv.setStartDate(this.solrRecordProjectStartdate(solrRecord));
        projectCsv.setEndDate(this.solrRecordProjectEnddate(solrRecord));
        projectCsv.setFunder(this.extractFunder(solrRecord));
        projectCsv.setParticipants(this.extractParticipants(solrRecord));
        return projectCsv;
    }

    private String solrRecordProjectTitle(SolrRecord solrRecord) {
        if (solrRecord == null) {
            return null;
        }
        Project project = solrRecord.getProject();
        if (project == null) {
            return null;
        }
        String title = project.getTitle();
        if (title == null) {
            return null;
        }
        return title;
    }

    private String solrRecordProjectStartdate(SolrRecord solrRecord) {
        if (solrRecord == null) {
            return null;
        }
        Project project = solrRecord.getProject();
        if (project == null) {
            return null;
        }
        String startdate = project.getStartdate();
        if (startdate == null) {
            return null;
        }
        return startdate;
    }

    private String solrRecordProjectEnddate(SolrRecord solrRecord) {
        if (solrRecord == null) {
            return null;
        }
        Project project = solrRecord.getProject();
        if (project == null) {
            return null;
        }
        String enddate = project.getEnddate();
        if (enddate == null) {
            return null;
        }
        return enddate;
    }
}

