/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.mappers.csv;

import eu.dnetlib.data.search.helpers.csv.ResearchProductCsv;
import eu.dnetlib.dhp.schema.solr.Author;
import eu.dnetlib.dhp.schema.solr.Pid;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring")
public interface ResearchProductCsvMapper {
    @Mappings(value={@Mapping(target="researchProduct", source="result.resulttype"), @Mapping(target="title", source="result.maintitle"), @Mapping(target="authors", expression="java(extractAuthor(solrRecord))"), @Mapping(target="publicationYear", source="result.publicationdate", defaultValue=""), @Mapping(target="doi", expression="java(extractDoi(solrRecord))"), @Mapping(target="type", source="result.resulttype"), @Mapping(target="peerReviewed", expression="java(extractPeerReviewed(solrRecord))"), @Mapping(target="diamondJournal", source="result.isInDiamondJournal"), @Mapping(target="journal", source="result.journal.name", defaultValue=""), @Mapping(target="downloadFrom", expression="java(extractDownloadFrom(solrRecord))"), @Mapping(target="publiclyFunded", source="result.publiclyFunded"), @Mapping(target="funder_Project", expression="java(extractFunder(solrRecord))"), @Mapping(target="access", source="result.bestaccessright.label"), @Mapping(target="green", source="result.isGreen"), @Mapping(target="oaColour", source="result.openAccessColor")})
    public ResearchProductCsv toResearchProductCsv(SolrRecord var1);

    @Mappings(value={@Mapping(target="researchProduct", source="result.resulttype"), @Mapping(target="title", source="result.maintitle"), @Mapping(target="authors", expression="java(extractAuthor(solrRecord))"), @Mapping(target="publicationYear", source="result.publicationdate", defaultValue=""), @Mapping(target="doi", expression="java(extractDoi(solrRecord))"), @Mapping(target="type", source="result.resulttype"), @Mapping(target="peerReviewed", expression="java(extractPeerReviewed(solrRecord))"), @Mapping(target="diamondJournal", source="result.isInDiamondJournal"), @Mapping(target="journal", source="result.journal.name", defaultValue=""), @Mapping(target="downloadFrom", expression="java(extractDownloadFrom(solrRecord))"), @Mapping(target="publiclyFunded", source="result.publiclyFunded"), @Mapping(target="access", source="result.bestaccessright.label"), @Mapping(target="green", source="result.isGreen"), @Mapping(target="oaColour", source="result.openAccessColor")})
    public ResearchProductCsv toSimpleResearchProductCsv(SolrRecord var1);

    default public List<String> extractAuthor(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getResult().getAuthor()).map(Collection::stream).orElseGet(Stream::empty).map(Author::getFullname).filter(Objects::nonNull).collect(Collectors.toList());
    }

    default public String extractFunder(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getLinks()).map(Collection::stream).orElseGet(Stream::empty).filter(relatedRecord -> "isProducedBy".equalsIgnoreCase(relatedRecord.getHeader().getRelationClass())).map(relatedRecord -> {
            String funderString = Optional.ofNullable(relatedRecord.getFunding()).map(funding -> Optional.ofNullable(funding.getFunder()).map(funder -> Optional.ofNullable(funder.getShortname()).orElse(funder.getName())).orElse("")).orElse("");
            String projectString = Optional.ofNullable(relatedRecord.getAcronym()).orElseGet(() -> Optional.ofNullable(relatedRecord.getProjectTitle()).orElse("Unknown"));
            funderString = funderString + "|" + projectString;
            String code = Optional.ofNullable(relatedRecord.getCode()).map(c -> "(" + c + ")").orElse("");
            return funderString + code;
        }).collect(Collectors.joining(";"));
    }

    default public List<String> extractDoi(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getPid()).map(Collection::stream).orElseGet(Stream::empty).filter(pid -> "doi".equalsIgnoreCase(pid.getTypeCode())).map(Pid::getValue).collect(Collectors.toList());
    }

    default public String extractPeerReviewed(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getResult().getInstance()).map(Collection::stream).orElseGet(Stream::empty).filter(instance -> "peerReviewed".equalsIgnoreCase(instance.getRefereed())).findFirst().map(instance -> "yes").orElse("no");
    }

    default public String extractDownloadFrom(SolrRecord solrRecord) {
        return Optional.ofNullable(solrRecord.getResult().getInstance()).map(Collection::stream).orElseGet(Stream::empty).filter(instance -> "OPEN".equalsIgnoreCase(instance.getAccessright().getCode())).findFirst().map(instance -> Optional.ofNullable(instance.getUrl()).filter(urls -> !urls.isEmpty()).map(urls -> (String)urls.get(0)).orElse("")).orElseGet(() -> Optional.ofNullable(solrRecord.getResult().getInstance()).map(Collection::stream).orElseGet(Stream::empty).findFirst().map(instance -> Optional.ofNullable(instance.getUrl()).filter(urls -> !urls.isEmpty()).map(urls -> (String)urls.get(0)).orElse("")).orElse(""));
    }
}

