/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.micrometer;

import io.micrometer.core.aop.TimedAspect;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.spring.web.servlet.WebMvcTags;
import io.micrometer.spring.web.servlet.WebMvcTagsProvider;
import io.prometheus.client.CollectorRegistry;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@ComponentScan
@Configuration
@Component
@EnableWebMvc
public class MicrometerComponent {
    @Bean
    public Clock micrometerClock() {
        return Clock.SYSTEM;
    }

    @Bean
    public PrometheusConfig prometheusConfig() {
        return PrometheusConfig.DEFAULT;
    }

    @Bean
    public PrometheusMeterRegistry prometheusMeterRegistry(PrometheusConfig config, CollectorRegistry collectorRegistry, Clock clock) {
        return new PrometheusMeterRegistry(config, collectorRegistry, clock);
    }

    @Bean
    public CollectorRegistry collectorRegistry() {
        return new CollectorRegistry(true);
    }

    @Bean
    public TimedAspect timedAspect(MeterRegistry registry) {
        return new TimedAspect(registry);
    }

    @Bean
    public WebMvcTagsProvider webMvcTagsProvider() {
        return new WebMvcTagsProvider(){

            public Iterable<Tag> httpLongRequestTags(HttpServletRequest httpServletRequest, Object o) {
                return new ArrayList<Tag>();
            }

            public Iterable<Tag> httpRequestTags(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Throwable throwable) {
                Tag uriTag = Tag.of((String)"status", (String)String.valueOf(httpServletResponse.getStatus()));
                return Tags.of((Tag[])new Tag[]{WebMvcTags.method((HttpServletRequest)httpServletRequest), uriTag, WebMvcTags.exception((Throwable)throwable), WebMvcTags.status((HttpServletResponse)httpServletResponse)});
            }
        };
    }
}

