/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.solr;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.google.gson.Gson;
import eu.dnetlib.api.data.SearchServiceException;
import eu.dnetlib.data.search.helpers.csv.CsvEntity;
import eu.dnetlib.data.search.helpers.csv.ResearchProductCsv;
import eu.dnetlib.data.search.helpers.csv.ResearchProductCsvConverter;
import eu.dnetlib.data.search.helpers.html.ResearchProductHtml;
import eu.dnetlib.data.search.mappers.csv.DatasourceCsvMapper;
import eu.dnetlib.data.search.mappers.csv.OrganizationCsvMapper;
import eu.dnetlib.data.search.mappers.csv.ProjectCsvMapper;
import eu.dnetlib.data.search.mappers.csv.ResearchProductCsvMapper;
import eu.dnetlib.data.search.mappers.html.ResearchProductsHtmlMapper;
import eu.dnetlib.data.search.solr.BrowseField;
import eu.dnetlib.data.search.transform.Transformer;
import eu.dnetlib.data.search.transform.TransformerException;
import eu.dnetlib.data.search.utils.solr.SolrResultSetOptionsUtil;
import eu.dnetlib.data.search.utils.solr.SolrResultsFormatter;
import eu.dnetlib.dhp.schema.solr.Datasource;
import eu.dnetlib.dhp.schema.solr.Organization;
import eu.dnetlib.dhp.schema.solr.Project;
import eu.dnetlib.dhp.schema.solr.Result;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import eu.dnetlib.domain.EPR;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.z3950.zing.cql.CQLParseException;

public class SolrResultSet
implements ResultSet<String> {
    private Logger logger = Logger.getLogger(this.getClass());
    private EPR epr = null;
    public SolrClient solrClient = null;
    private NamedList<String> queryOpts = new NamedList();
    long size = -1L;
    final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private PrometheusMeterRegistry registry;
    DatasourceCsvMapper datasourceCsvMapper;
    OrganizationCsvMapper organizationCsvMapper;
    ProjectCsvMapper projectCsvMapper;
    ResearchProductCsvMapper researchProductCsvMapper;
    ResearchProductCsvConverter researchProductCsvConverter;
    ResearchProductsHtmlMapper researchProductsHtmlMapper;
    CsvMapper datasourceMapper = new CsvMapper();
    CsvMapper organizationMapper = new CsvMapper();
    CsvMapper projectMapper = new CsvMapper();
    CsvMapper researchProductMapper = new CsvMapper();
    List<FacetField> facetFields = null;

    public SolrResultSet(EPR epr, CloudSolrClient cloudSolrClient, PrometheusMeterRegistry registry, DatasourceCsvMapper datasourceCsvMapper, OrganizationCsvMapper organizationCsvMapper, ProjectCsvMapper projectCsvMapper, ResearchProductCsvMapper researchProductCsvMapper, ResearchProductCsvConverter researchProductCsvConverter, ResearchProductsHtmlMapper researchProductsHtmlMapper) throws IOException, CQLParseException, SearchServiceException {
        this.epr = epr;
        this.solrClient = cloudSolrClient;
        this.queryOpts = SolrResultSetOptionsUtil.extractQueryOptions(epr.getParameter("query"));
        String layout = epr.getParameter("layout");
        String mdformat = epr.getParameter("mdformat");
        String interpretation = epr.getParameter("interpretation");
        this.datasourceCsvMapper = datasourceCsvMapper;
        this.organizationCsvMapper = organizationCsvMapper;
        this.projectCsvMapper = projectCsvMapper;
        this.researchProductCsvMapper = researchProductCsvMapper;
        this.researchProductCsvConverter = researchProductCsvConverter;
        this.researchProductsHtmlMapper = researchProductsHtmlMapper;
        System.out.println("SOLR CLIENT " + this.solrClient);
        ((CloudSolrClient)this.solrClient).setDefaultCollection(mdformat + "-" + layout + "-" + interpretation);
        this.registry = registry;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isAlive() {
        return true;
    }

    public void close() {
    }

    public int size() {
        return (int)this.size;
    }

    @Deprecated
    public List<String> getElements(int from, int to) {
        return this.get(from, to);
    }

    @Deprecated
    public List<String> get(int from, int to) {
        ArrayList<String> res = new ArrayList<String>();
        QueryResponse rsp = null;
        HashMap map = new HashMap();
        this.logger.debug((Object)("from: " + from));
        this.logger.debug((Object)("to: " + to));
        this.queryOpts.add("start", (Object)(from + 1 + ""));
        this.queryOpts.add("rows", (Object)(to + 1 + ""));
        try {
            rsp = this.solrClient.query(SolrParams.toSolrParams(this.queryOpts));
            this.facetFields = rsp.getFacetFields();
            SolrDocumentList docs = rsp.getResults();
            if (this.facetFields != null && !this.facetFields.isEmpty()) {
                for (int i = from - 1; i < to; ++i) {
                    for (FacetField field : this.facetFields) {
                        if (field.getValueCount() <= i) continue;
                        BrowseField bf = new BrowseField();
                        bf.setId(((FacetField.Count)field.getValues().get(i)).getName());
                        bf.setName(((FacetField.Count)field.getValues().get(i)).getName());
                        bf.setCount(((FacetField.Count)field.getValues().get(i)).getCount() + "");
                        if (map.get(field.getName()) == null) {
                            map.put(field.getName(), new ArrayList());
                        }
                        ((List)map.get(field.getName())).add(new Gson().toJson((Object)bf));
                    }
                }
                for (Map.Entry facetEntry : map.entrySet()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("\"" + (String)facetEntry.getKey() + "\" : ");
                    builder.append(facetEntry.getValue());
                    res.add(builder.toString());
                }
            }
            this.logger.debug((Object)("time: " + rsp.getElapsedTime()));
            this.logger.debug((Object)("found: " + docs.getNumFound()));
            this.logger.debug((Object)("docs: " + docs.size()));
            for (int i = 0; i < docs.size(); ++i) {
                String result = (String)((SolrDocument)docs.get(i)).get((Object)"__result");
                res.add(result);
            }
            return res;
        }
        catch (SolrServerException sse) {
            this.logger.error((Object)"Fail to get results from Solr. ", (Throwable)sse);
        }
        catch (IOException ioe) {
            this.logger.error((Object)"Fail to get results from Solr. ", (Throwable)ioe);
        }
        return null;
    }

    public EPR getEpr() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, List<String>> newGet(int from, int to, String format, Transformer transformer, Transformer oldRefineTransformer, boolean timeout, String timeoutValue) throws SearchServiceException {
        ArrayList<String> refineSolrResults = new ArrayList<String>();
        ArrayList<Object> searchSolrResults = new ArrayList<Object>();
        QueryResponse rsp = null;
        HashMap map = new HashMap();
        if (from < 0) {
            from = 0;
        }
        if (to < 0) {
            to = 0;
        }
        this.queryOpts.add("start", (Object)(from * to + ""));
        this.queryOpts.add("rows", (Object)(to + ""));
        try {
            if (timeout) {
                if (timeoutValue != null && Integer.valueOf(timeoutValue) == -1) {
                    this.logger.warn((Object)("Timeout value is -1. Timeout will not be set for query: " + (String)this.queryOpts.get("q")));
                    timeout = false;
                } else if (Integer.valueOf(timeoutValue) < 500) {
                    this.logger.warn((Object)("Timeout is less than 500ms. We fall back to the default 1000ms for query:" + (String)this.queryOpts.get("q")));
                    this.queryOpts.add("timeAllowed", (Object)"500");
                } else if (timeout) {
                    this.queryOpts.add("timeAllowed", (Object)timeoutValue);
                }
            }
        }
        catch (NumberFormatException nfe) {
            this.logger.warn((Object)"NumberFormatException occurred. Timeout not properly set. We fall back to the default 1000ms.");
            this.queryOpts.add("timeAllowed", (Object)"500");
        }
        this.logger.info((Object)("timeout: " + timeout + ", timeout value: " + (String)this.queryOpts.get("timeAllowed")));
        long startTime = System.nanoTime();
        try {
            Timer.Sample timer = Timer.start((MeterRegistry)this.registry);
            rsp = this.solrClient.query(SolrParams.toSolrParams(this.queryOpts));
            timer.stop(this.registry.timer("solr.server.response.duration", new String[0]));
            long estimatedTime = System.nanoTime() - startTime;
            this.logger.info((Object)("Solrj time " + estimatedTime / 1000000L + " milliseconds for query:" + (String)this.queryOpts.get("q") + " and facets " + this.queryOpts.getAll("facet.field") + " and fq " + this.queryOpts.getAll("fq") + " and sorts " + this.queryOpts.getAll("sort") + " from: " + from + " and size " + to + " with timeout: " + timeout));
            this.facetFields = rsp.getFacetFields();
            SolrDocumentList docs = rsp.getResults();
            this.size = docs.getNumFound();
            if (this.facetFields != null && !this.facetFields.isEmpty()) {
                if (format != null && format.equals("application/json")) {
                    for (FacetField facetField : this.facetFields) {
                        map.put(facetField.getName(), new ArrayList());
                        Object var20_29 = null;
                        for (int i = 0; i < facetField.getValueCount(); ++i) {
                            BrowseField browseField = new BrowseField();
                            browseField.setId(((FacetField.Count)facetField.getValues().get(i)).getName());
                            Object[] facetedValues = ((FacetField.Count)facetField.getValues().get(i)).getName().split("\\|\\|", 2);
                            this.logger.debug((Object)("faceted values " + Arrays.toString(facetedValues)));
                            if (facetedValues.length > 1) {
                                browseField.setName((String)facetedValues[1]);
                                this.logger.debug((Object)("faceted values [1] " + (String)facetedValues[1]));
                            } else if (((FacetField.Count)facetField.getValues().get(i)).getName().split("_\\:\\:", 2).length > 1) {
                                browseField.setName(((FacetField.Count)facetField.getValues().get(i)).getName().split("\\:\\:", 2)[1].replaceAll("\\:\\:", "\\|"));
                            } else {
                                browseField.setName(((FacetField.Count)facetField.getValues().get(i)).getName());
                            }
                            browseField.setCount(((FacetField.Count)facetField.getValues().get(i)).getCount() + "");
                            ((List)map.get(facetField.getName())).add(new Gson().toJson((Object)browseField));
                        }
                    }
                    StringBuilder builder = null;
                    for (Map.Entry entry : map.entrySet()) {
                        builder = new StringBuilder();
                        builder.append("\"" + (String)entry.getKey() + "\" : ");
                        builder.append(entry.getValue());
                        refineSolrResults.add(builder.toString());
                    }
                } else {
                    this.logger.debug((Object)"Creating old browse results.");
                    this.createXmlRefineFields(refineSolrResults, oldRefineTransformer);
                }
            }
            startTime = System.nanoTime();
            for (int i = 0; i < docs.size(); ++i) {
                void var19_27;
                block27: {
                    String string = (String)((SolrDocument)docs.get(i)).get((Object)"__result");
                    try {
                        if (transformer == null) break block27;
                        String string2 = string.replaceAll("<em>", "").replaceAll("</em>", "");
                        String string3 = transformer.transform(string2);
                    }
                    catch (TransformerException transformerException) {
                        this.logger.warn((Object)("Error transforming " + string), (Throwable)transformerException);
                        continue;
                    }
                }
                if (format != null && format.equals("application/json")) {
                    searchSolrResults.add(SolrResultsFormatter.xml2Json((String)var19_27));
                    continue;
                }
                searchSolrResults.add(var19_27);
            }
            estimatedTime = System.nanoTime() - startTime;
            this.logger.info((Object)("Internal transformation time " + estimatedTime / 1000000L + " milliseconds for query:" + (String)this.queryOpts.get("q") + " and facets " + this.queryOpts.getAll("facet.field") + " and fq " + this.queryOpts.getAll("fq") + " from: " + from + " and size " + to));
            HashMap<String, List<String>> response = new HashMap<String, List<String>>();
            response.put("refine", refineSolrResults);
            response.put("search", searchSolrResults);
            return response;
        }
        catch (SolrServerException sse) {
            this.logger.error((Object)("Error calling Solr for  query:" + (String)this.queryOpts.get("q") + " and facets " + this.queryOpts.getAll("facet.field") + " and fq " + this.queryOpts.getAll("fq") + " from: " + from + " and size " + to), (Throwable)sse);
            throw new SearchServiceException("Error contacting Solr.", (Throwable)sse);
        }
        catch (IOException ioe) {
            this.logger.error((Object)("Error calling Solr for  query:" + (String)this.queryOpts.get("q") + " and facets " + this.queryOpts.getAll("facet.field") + " and fq " + this.queryOpts.getAll("fq") + " from: " + from + " and size " + to), (Throwable)ioe);
            throw new SearchServiceException("Error reading results from Solr.", (Throwable)ioe);
        }
    }

    public Map<String, List<String>> newJsonGet(int from, int to, String format, Transformer transformer, Transformer oldRefineTransformer, boolean timeout, String timeoutValue) throws SearchServiceException {
        ArrayList<String> refineSolrResults = new ArrayList<String>();
        ArrayList<String> searchSolrResults = new ArrayList<String>();
        QueryResponse rsp = null;
        HashMap map = new HashMap();
        if (from < 0) {
            from = 0;
        }
        if (to < 0) {
            to = 0;
        }
        this.queryOpts.add("start", (Object)(from * to + ""));
        this.queryOpts.add("rows", (Object)(to + ""));
        try {
            if (timeout) {
                if (timeoutValue != null && Integer.valueOf(timeoutValue) == -1) {
                    this.logger.warn((Object)("Timeout value is -1. Timeout will not be set for query: " + (String)this.queryOpts.get("q")));
                    timeout = false;
                } else if (Integer.valueOf(timeoutValue) < 500) {
                    this.logger.warn((Object)("Timeout is less than 500ms. We fall back to the default 1000ms for query:" + (String)this.queryOpts.get("q")));
                    this.queryOpts.add("timeAllowed", (Object)"500");
                } else if (timeout) {
                    this.queryOpts.add("timeAllowed", (Object)timeoutValue);
                }
            }
        }
        catch (NumberFormatException nfe) {
            this.logger.warn((Object)"NumberFormatException occurred. Timeout not properly set. We fall back to the default 1000ms.");
            this.queryOpts.add("timeAllowed", (Object)"500");
        }
        this.logger.info((Object)("timeout: " + timeout + ", timeout value: " + (String)this.queryOpts.get("timeAllowed")));
        long startTime = System.nanoTime();
        try {
            Timer.Sample timer = Timer.start((MeterRegistry)this.registry);
            rsp = this.solrClient.query(SolrParams.toSolrParams(this.queryOpts));
            timer.stop(this.registry.timer("solr.server.response.duration", new String[0]));
            long estimatedTime = System.nanoTime() - startTime;
            this.logger.info((Object)("Solrj time " + estimatedTime / 1000000L + " milliseconds for query:" + (String)this.queryOpts.get("q") + " and facets " + this.queryOpts.getAll("facet.field") + " and fq " + this.queryOpts.getAll("fq") + " and sorts " + this.queryOpts.getAll("sort") + " from: " + from + " and size " + to + " with timeout: " + timeout));
            this.facetFields = rsp.getFacetFields();
            SolrDocumentList docs = rsp.getResults();
            this.size = docs.getNumFound();
            if (this.facetFields != null && !this.facetFields.isEmpty()) {
                if (format != null && format.equals("application/json")) {
                    for (FacetField facetField : this.facetFields) {
                        map.put(facetField.getName(), new ArrayList());
                        Object var20_27 = null;
                        for (int i = 0; i < facetField.getValueCount(); ++i) {
                            BrowseField browseField = new BrowseField();
                            browseField.setId(((FacetField.Count)facetField.getValues().get(i)).getName());
                            Object[] facetedValues = ((FacetField.Count)facetField.getValues().get(i)).getName().split("\\|\\|", 2);
                            this.logger.debug((Object)("faceted values " + Arrays.toString(facetedValues)));
                            if (facetedValues.length > 1) {
                                browseField.setName((String)facetedValues[1]);
                                this.logger.debug((Object)("faceted values [1] " + (String)facetedValues[1]));
                            } else if (((FacetField.Count)facetField.getValues().get(i)).getName().split("_\\:\\:", 2).length > 1) {
                                browseField.setName(((FacetField.Count)facetField.getValues().get(i)).getName().split("\\:\\:", 2)[1].replaceAll("\\:\\:", "\\|"));
                            } else {
                                browseField.setName(((FacetField.Count)facetField.getValues().get(i)).getName());
                            }
                            browseField.setCount(((FacetField.Count)facetField.getValues().get(i)).getCount() + "");
                            ((List)map.get(facetField.getName())).add(new Gson().toJson((Object)browseField));
                        }
                    }
                    StringBuilder builder = null;
                    for (Map.Entry entry : map.entrySet()) {
                        builder = new StringBuilder();
                        builder.append("\"" + (String)entry.getKey() + "\" : ");
                        builder.append(entry.getValue());
                        refineSolrResults.add(builder.toString());
                    }
                } else {
                    this.logger.debug((Object)"Creating old browse results.");
                    this.createXmlRefineFields(refineSolrResults, oldRefineTransformer);
                }
            }
            startTime = System.nanoTime();
            for (int i = 0; i < docs.size(); ++i) {
                String string = (String)((SolrDocument)docs.get(i)).get((Object)"__json");
                searchSolrResults.add(string);
            }
            estimatedTime = System.nanoTime() - startTime;
            this.logger.info((Object)("Internal transformation time " + estimatedTime / 1000000L + " milliseconds for query:" + (String)this.queryOpts.get("q") + " and facets " + this.queryOpts.getAll("facet.field") + " and fq " + this.queryOpts.getAll("fq") + " from: " + from + " and size " + to));
            HashMap<String, List<String>> response = new HashMap<String, List<String>>();
            response.put("refine", refineSolrResults);
            response.put("search", searchSolrResults);
            return response;
        }
        catch (SolrServerException sse) {
            this.logger.error((Object)("Error calling Solr for  query:" + (String)this.queryOpts.get("q") + " and facets " + this.queryOpts.getAll("facet.field") + " and fq " + this.queryOpts.getAll("fq") + " from: " + from + " and size " + to), (Throwable)sse);
            throw new SearchServiceException("Error contacting Solr.", (Throwable)sse);
        }
        catch (IOException ioe) {
            this.logger.error((Object)("Error calling Solr for  query:" + (String)this.queryOpts.get("q") + " and facets " + this.queryOpts.getAll("facet.field") + " and fq " + this.queryOpts.getAll("fq") + " from: " + from + " and size " + to), (Throwable)ioe);
            throw new SearchServiceException("Error reading results from Solr.", (Throwable)ioe);
        }
    }

    public void cursorGet(Transformer transformer, boolean special, boolean hasTitle, boolean isHtml, int limit, OutputStream os) throws SolrServerException, SearchServiceException {
        System.out.println("Datasource Mapper " + this.datasourceCsvMapper);
        int rows = 500;
        int limitCounter = limit > 0 ? limit / rows : -1;
        int headerCounter = limit > 0 ? limit / rows : -1;
        this.setupQueryOptions(rows);
        String cursorMark = "*";
        String nextCursorMark = "";
        try {
            QueryResponse resp = null;
            if (isHtml) {
                SolrResultSet.initializeHtmlTable(os);
            }
            do {
                resp = this.solrClient.query(SolrParams.toSolrParams(this.queryOpts));
                nextCursorMark = resp.getNextCursorMark();
                for (int i = 0; i < resp.getResults().size(); ++i) {
                    SolrRecord record = (SolrRecord)this.objectMapper.readValue((String)((SolrDocument)resp.getResults().get(i)).get((Object)"__json"), (TypeReference)new TypeReference<SolrRecord>(){});
                    if (!isHtml) {
                        CsvEntity csvEntity = this.createCsvEntity(record);
                        CsvMapper csvMapper = this.selectCsvMapper(record);
                        if (hasTitle && i == 0 && limitCounter == headerCounter) {
                            this.writeHeader(csvMapper, csvEntity, os);
                        }
                        if (special) {
                            List<ResearchProductCsv> flattenedProducts = this.researchProductCsvConverter.flattenProjects(record);
                            CsvSchema schema = csvMapper.schemaFor(csvEntity.getClass()).withoutHeader();
                            ObjectWriter csvWriterRow = this.researchProductMapper.writer((FormatSchema)schema);
                            for (ResearchProductCsv internalCsvEntity : flattenedProducts) {
                                String csvRow = csvWriterRow.writeValueAsString((Object)internalCsvEntity);
                                os.write(csvRow.getBytes());
                                os.flush();
                            }
                            continue;
                        }
                        if (csvEntity == null || csvMapper == null) continue;
                        this.writeCsvEntity(csvMapper, csvEntity, special, os);
                        continue;
                    }
                    this.writeHtmlRow(os, record);
                }
                this.updateCursorMark(nextCursorMark);
            } while (!cursorMark.equals(nextCursorMark) && --limitCounter != 0);
        }
        catch (IOException ioe) {
            this.logger.error((Object)"Error executing solr query. ", (Throwable)ioe);
        }
    }

    private void writeHtmlRow(OutputStream os, SolrRecord record) throws IOException {
        StringBuilder htmlBuilder = new StringBuilder();
        ResearchProductHtml researchProductHtml = this.researchProductsHtmlMapper.toResearchProductHtml(record);
        htmlBuilder.append("<tr>").append("<td>").append(researchProductHtml.getType()).append("</td>").append("<td>").append(researchProductHtml.getTitle()).append("</td>").append("<td>").append(researchProductHtml.getAuthors()).append("</td>").append("<td>").append(researchProductHtml.getPublicationYear()).append("</td>").append("<td>").append(researchProductHtml.getDoi()).append("</td>").append("<td>").append(researchProductHtml.getPermanentIdentifier()).append("</td>").append("<td>").append(researchProductHtml.getPublicationType()).append("</td>").append("<td>").append(researchProductHtml.getJournal()).append("</td>").append("<td>").append(researchProductHtml.getProjectName_gaNumber()).append("</td>").append("<td>").append(researchProductHtml.getAccessMode()).append("</td>").append("</tr>");
        os.write(htmlBuilder.toString().getBytes());
        os.flush();
    }

    private CsvEntity createCsvEntity(SolrRecord solrRecord) {
        Datasource datasource = solrRecord.getDatasource();
        Project project = solrRecord.getProject();
        Result result = solrRecord.getResult();
        Organization organization = solrRecord.getOrganization();
        if (datasource != null) {
            return this.datasourceCsvMapper.toDatasourceCsv(solrRecord);
        }
        if (project != null) {
            return this.projectCsvMapper.toProjectCsv(solrRecord);
        }
        if (result != null) {
            return this.researchProductCsvMapper.toResearchProductCsv(solrRecord);
        }
        if (organization != null) {
            return this.organizationCsvMapper.toOrganizationCsv(solrRecord);
        }
        return null;
    }

    private CsvMapper selectCsvMapper(SolrRecord solrRecord) {
        Datasource datasource = solrRecord.getDatasource();
        Project project = solrRecord.getProject();
        Result result = solrRecord.getResult();
        Organization organization = solrRecord.getOrganization();
        if (datasource != null) {
            return this.datasourceMapper;
        }
        if (project != null) {
            return this.projectMapper;
        }
        if (result != null) {
            return this.researchProductMapper;
        }
        if (organization != null) {
            return this.organizationMapper;
        }
        return null;
    }

    private static void initializeHtmlTable(OutputStream os) throws IOException {
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<table>").append("<thead><tr>").append("<th>Type</th><th>Title</th><th>Authors</th><th>Publication Year</th><th>DOI</th><th>Permanent Identifier</th><th>Publication type</th><th>Journal</th><th>Project Name (GA Number)</th><th>Access Mode</th>").append("</tr></thead><tbody>");
        os.write(htmlBuilder.toString().getBytes());
        os.flush();
    }

    public void writeHeader(CsvMapper csvMapper, CsvEntity csvEntity, OutputStream os) throws IOException {
        CsvSchema schema = csvMapper.schemaFor(csvEntity.getClass()).withHeader();
        ObjectWriter csvWriterHeader = csvMapper.writer((FormatSchema)schema);
        String csvHeader = csvWriterHeader.writeValueAsString(csvEntity.getClass()).split(System.lineSeparator())[0];
        os.write(csvHeader.getBytes());
        os.write("\n".getBytes());
        os.flush();
    }

    public void writeCsvEntity(CsvMapper csvMapper, CsvEntity csvEntity, boolean special, OutputStream os) throws IOException {
        CsvSchema schema = csvMapper.schemaFor(csvEntity.getClass()).withoutHeader();
        ObjectWriter csvWriterRow = csvMapper.writer((FormatSchema)schema.withoutHeader());
        String csvRow = csvWriterRow.writeValueAsString((Object)csvEntity);
        os.write(csvRow.getBytes());
        os.flush();
    }

    public void updateCursorMark(String nextCursorMark) {
        this.queryOpts.remove("cursorMark");
        this.queryOpts.add("cursorMark", (Object)nextCursorMark);
    }

    private void setupQueryOptions(int rows) {
        this.queryOpts.add("start", (Object)"0");
        this.queryOpts.add("rows", (Object)"0");
        this.queryOpts.remove("rows");
        this.queryOpts.add("rows", (Object)(rows + ""));
        this.queryOpts.add("shards.tolerant", (Object)"true");
        this.queryOpts.add("cursorMark", (Object)"*");
        this.queryOpts.add("sort", (Object)"__indexrecordidentifier asc");
    }

    @Deprecated
    private void createXmlRefineFields(List<String> res, Transformer oldRefineTransformer) {
        int max = -12;
        for (FacetField field : this.facetFields) {
            this.logger.debug((Object)("field " + field.getName() + " has count " + field.getValueCount()));
            if (field.getValueCount() <= max) continue;
            max = field.getValueCount();
        }
        this.logger.debug((Object)("max " + max));
        for (int i = 0; i < max; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append("<row>");
            for (FacetField field : this.facetFields) {
                if (field.getValueCount() <= i) continue;
                sb.append("<groupresult field=\"").append(field.getName()).append("\">");
                sb.append("<count>").append(((FacetField.Count)field.getValues().get(i)).getCount()).append("</count>");
                sb.append("<originalValue>").append(StringEscapeUtils.escapeXml((String)((FacetField.Count)field.getValues().get(i)).getName())).append("</originalValue>");
                String[] facetValues = ((FacetField.Count)field.getValues().get(i)).getName().split("\\|\\|");
                if (facetValues.length > 1) {
                    sb.append("<value>").append(StringEscapeUtils.escapeXml((String)facetValues[1])).append("</value>");
                } else {
                    sb.append("<value>").append(StringEscapeUtils.escapeXml((String)facetValues[0])).append("</value>");
                }
                sb.append("</groupresult>");
            }
            sb.append("</row>");
            try {
                res.add(oldRefineTransformer.transform(sb.toString()));
                continue;
            }
            catch (TransformerException te) {
                this.logger.error((Object)("Cannot transform refine for: " + sb.toString()), (Throwable)te);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String json = "{\"header\":{\"id\":\"07b5c0ccd4fe::6cc02bea6ffd14eb21e6de7fa7e4271d\",\"originalId\":[\"07b5c0ccd4fe::2412-8368\"],\"recordType\":\"datasource\",\"deletedbyinference\":false},\"collectedfrom\":[{\"dsId\":\"10|openaire____::160a261e5d06fd542c2efcac6e17e08c\",\"dsName\":\"RS Global Journals\"}],\"datasource\":{\"datasourcetype\":{\"code\":\"pubsrepository::journal\",\"label\":\"Journal\"},\"datasourcetypeui\":{\"code\":\"Journal archive\",\"label\":\"Journal archive\"},\"eosctype\":{\"code\":\"Data Source\",\"label\":\"Data Source\"},\"eoscdatasourcetype\":{\"code\":\"Journal archive\",\"label\":\"Journal Archive\"},\"openairecompatibility\":{\"code\":\"hostedBy\",\"label\":\"collected from a compatible aggregator\"},\"officialname\":\"International Journal of Innovative Technologies in Economy\",\"englishname\":\"International Journal of Innovative Technologies in Economy\",\"namespaceprefix\":\"ojs_24128368\",\"latitude\":\"0.0\",\"longitude\":\"0.0\",\"odnumberofitems\":\"0.0\",\"versioning\":false,\"versioncontrol\":false,\"journal\":{\"name\":\"International Journal of Innovative Technologies in Economy\",\"issnPrinted\":\"2412-8368\",\"issnOnline\":\"2414-1305\"},\"thematic\":false,\"contentpolicies\":[{\"code\":\"Journal articles\",\"label\":\"Journal articles\"}],\"consenttermsofuse\":false,\"fulltextdownload\":false}}";
        SolrRecord record = (SolrRecord)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<SolrRecord>(){});
    }

    private String formatColumn(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    private String formatColumn(List<String> value) {
        if (value == null) {
            return "";
        }
        if (value.size() > 1) {
            return String.join((CharSequence)";", value);
        }
        return value.get(0);
    }
}

