/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.solr;

import eu.dnetlib.api.data.SearchServiceException;
import eu.dnetlib.data.search.helpers.csv.ResearchProductCsvConverter;
import eu.dnetlib.data.search.mappers.csv.DatasourceCsvMapper;
import eu.dnetlib.data.search.mappers.csv.OrganizationCsvMapper;
import eu.dnetlib.data.search.mappers.csv.ProjectCsvMapper;
import eu.dnetlib.data.search.mappers.csv.ResearchProductCsvMapper;
import eu.dnetlib.data.search.mappers.html.ResearchProductsHtmlMapper;
import eu.dnetlib.data.search.solr.SolrResultSet;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.SecureDriverResource;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.z3950.zing.cql.CQLParseException;

public class SolrResultSetFactory
implements ResultSetFactory {
    private Logger logger = Logger.getLogger(this.getClass());
    @Autowired
    private PrometheusMeterRegistry prometheusMeterRegistry;
    @Autowired
    DatasourceCsvMapper datasourceCsvMapper;
    @Autowired
    OrganizationCsvMapper organizationCsvMapper;
    @Autowired
    ProjectCsvMapper projectCsvMapper;
    @Autowired
    ResearchProductCsvMapper researchProductCsvMapper;
    @Autowired
    ResearchProductCsvConverter researchProductCsvConverter;
    @Autowired
    ResearchProductsHtmlMapper researchProductsHtmlMapper;
    private CloudSolrClient solrClient;
    private CloudSolrClient solrClientWithSocketTimeout;

    public void init(String[] zkservers, int socketTimeout) {
        this.logger.info((Object)"Initialization of clients.");
        this.logger.info((Object)"solrClient is set without socket timeout.");
        this.solrClient = new CloudSolrClient.Builder().withZkHost(Arrays.asList(zkservers)).build();
        if (socketTimeout != -1) {
            this.logger.info((Object)("solrClientWithSocketTimeout is set with socket timeout " + socketTimeout));
            this.solrClientWithSocketTimeout = ((CloudSolrClient.Builder)new CloudSolrClient.Builder().withZkHost(Arrays.asList(zkservers)).withSocketTimeout(socketTimeout)).build();
        } else {
            this.logger.info((Object)"solrClientWithSocketTimeout has \u039d\u039f actual timeout as the socketTimeout property is set to -1.");
            this.solrClientWithSocketTimeout = new CloudSolrClient.Builder().withZkHost(Arrays.asList(zkservers)).build();
        }
    }

    public ResultSet<String> createResultSetWithSocketTimeout(EPR epr) throws IOException, CQLParseException, SearchServiceException {
        this.logger.info((Object)("Get RS with solrClient With SocketTimeout for EPR: " + epr));
        return new SolrResultSet(epr, this.solrClientWithSocketTimeout, this.prometheusMeterRegistry, this.datasourceCsvMapper, this.organizationCsvMapper, this.projectCsvMapper, this.researchProductCsvMapper, this.researchProductCsvConverter, this.researchProductsHtmlMapper);
    }

    public ResultSet<String> createResultSetWithoutSocketTimeout(EPR epr) throws IOException, CQLParseException, SearchServiceException {
        this.logger.info((Object)("Get RS with solrClient Without SocketTimeout for EPR: " + epr));
        return new SolrResultSet(epr, this.solrClient, this.prometheusMeterRegistry, this.datasourceCsvMapper, this.organizationCsvMapper, this.projectCsvMapper, this.researchProductCsvMapper, this.researchProductCsvConverter, this.researchProductsHtmlMapper);
    }

    public ResultSet<String> createResultSet(EPR epr) {
        this.logger.info((Object)("Get RS with solrClient Without SocketTimeout for EPR: " + epr));
        try {
            return new SolrResultSet(epr, this.solrClient, this.prometheusMeterRegistry, this.datasourceCsvMapper, this.organizationCsvMapper, this.projectCsvMapper, this.researchProductCsvMapper, this.researchProductCsvConverter, this.researchProductsHtmlMapper);
        }
        catch (IOException ioe) {
            this.logger.error((Object)"Error in search. I will return null resultSet.", (Throwable)ioe);
        }
        catch (CQLParseException cqlpe) {
            this.logger.error((Object)"Error in cql parse. I will return null resultSet.", (Throwable)cqlpe);
        }
        catch (SearchServiceException sse) {
            this.logger.error((Object)"Error in search.", (Throwable)sse);
        }
        return null;
    }

    public <D> ResultSet<D> createResultSet(EPR epr, Class<D> resourceClass) {
        return this.createResultSet(epr);
    }

    public <D> ResultSet<D> createResultSet(ResultSet<?> rs, Class<D> resourceClass) {
        throw new UnsupportedOperationException();
    }

    public <D extends SecureDriverResource> ResultSet<D> createSecurityAwareRS(EPR epr, Class<D> resourceClass) {
        throw new UnsupportedOperationException();
    }
}

