/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.transform;

import eu.dnetlib.data.search.transform.Transformer;
import eu.dnetlib.data.search.transform.TransformerException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;

public class XsltTransformer
implements Transformer {
    private final String xslt;
    private final Logger logger = Logger.getLogger(XsltTransformer.class);
    private javax.xml.transform.Transformer xmlTransformer = null;
    private StringWriter xmlResultResource = new StringWriter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XsltTransformer(String xslt) throws TransformerConfigurationException, TransformerFactoryConfigurationError {
        this.xslt = xslt;
        XsltTransformer xsltTransformer = this;
        synchronized (xsltTransformer) {
            this.xmlTransformer = TransformerFactory.newInstance().newTemplates(new StreamSource(new StringReader(xslt))).newTransformer();
            this.xmlTransformer.setOutputProperty("encoding", "UTF-8");
        }
    }

    @Override
    public synchronized String transform(String input) throws TransformerException {
        this.xmlResultResource.getBuffer().setLength(0);
        try {
            this.xmlTransformer.transform(new StreamSource(new StringReader(input)), new StreamResult(this.xmlResultResource));
        }
        catch (javax.xml.transform.TransformerException e) {
            this.logger.warn((Object)("Error transforming xml: " + input), (Throwable)e);
            throw new TransformerException("Error transforming xml: " + input, e);
        }
        return this.xmlResultResource.getBuffer().toString();
    }

    public String getXslt() {
        return this.xslt;
    }
}

