/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.utils.cql;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CQLQueryBuilder {
    private static final Logger logger = Logger.getLogger(CQLQueryBuilder.class);

    public static void appendQuery(StringBuilder stringBuilder, String query) {
        if (query != null && !query.trim().isEmpty()) {
            CQLQueryBuilder.appendSimpleTerm(stringBuilder, Operator.AND, query);
        }
    }

    public static void appendKeywords(StringBuilder stringBuilder, String keywords) {
        if (keywords != null && !keywords.trim().isEmpty()) {
            ArrayList<String> matchList = new ArrayList<String>();
            Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
            Matcher regexMatcher = regex.matcher(keywords);
            while (regexMatcher.find()) {
                matchList.add(regexMatcher.group());
            }
            for (String keyword : matchList) {
                if (keyword.endsWith("\"") && keyword.startsWith("\"")) {
                    CQLQueryBuilder.appendSimpleQuotedTerm(stringBuilder, Operator.AND, keyword);
                    continue;
                }
                CQLQueryBuilder.appendSimpleTerm(stringBuilder, Operator.AND, keyword.replaceAll("\"", ""));
            }
        }
    }

    public static void appendSimpleTerm(StringBuilder stringBuilder, Operator queryOperator, String value) {
        if (!stringBuilder.toString().isEmpty()) {
            stringBuilder.append(' ').append((Object)queryOperator).append(" (").append(value).append(')');
        } else {
            stringBuilder.append("(").append(value).append(')');
        }
    }

    public static void appendSimpleQuotedTerm(StringBuilder stringBuilder, Operator queryOperator, String value) {
        if (!stringBuilder.toString().isEmpty()) {
            stringBuilder.append(' ').append((Object)queryOperator).append(" (__all exact ").append(value).append(")");
        } else {
            stringBuilder.append(" (__all exact ").append(value).append(")");
        }
    }

    public static void appendFieldTerm(StringBuilder stringBuilder, Operator queryOperator, String indexFieldName, Operator termOperator, String fieldValue) {
        stringBuilder.append(' ').append((Object)queryOperator).append(" (").append(indexFieldName).append(' ').append((Object)termOperator).append(' ').append(fieldValue).append(")");
    }

    public static void appendFieldQuotedTerm(StringBuilder stringBuilder, Operator queryOperator, String indexFieldName, Operator termOperator, String fieldValue) {
        stringBuilder.append(' ').append((Object)queryOperator).append(" (").append(indexFieldName).append(' ').append((Object)Operator.EXACT).append(" \"").append(fieldValue).append("\")");
    }

    public static void appendFieldTerms(StringBuilder stringBuilder, Operator queryOperator, String indexFieldName, Operator termOperator, List<String> fieldValues) {
        for (String fieldValue : fieldValues) {
            CQLQueryBuilder.appendFieldTerm(stringBuilder, queryOperator, indexFieldName, termOperator, fieldValue);
        }
    }

    public static void appendFieldQuotedTerms(StringBuilder stringBuilder, Operator queryOperator, String indexFieldName, Operator termOperator, List<String> fieldValues) {
        for (String fieldValue : fieldValues) {
            CQLQueryBuilder.appendFieldQuotedTerm(stringBuilder, queryOperator, indexFieldName, termOperator, fieldValue);
        }
    }

    public static void appendEnhancedKeywords(StringBuilder stringBuilder, String keywords) {
        if (keywords != null && !keywords.trim().isEmpty()) {
            CQLQueryBuilder.appendSimpleTerm(stringBuilder, Operator.AND, keywords);
        }
    }

    public static enum Operator {
        AND("and"),
        OR("or"),
        NOT("not"),
        EQUAL("="),
        EXACT("exact"),
        NOTEQUAL("<>"),
        NONE("");

        private String value;

        private Operator(String value) {
            this.value = value;
        }

        private String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

