/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.utils.solr;

import eu.dnetlib.api.data.SearchServiceException;
import eu.dnetlib.functionality.cql.CqlTranslatorImpl;
import eu.dnetlib.functionality.cql.lucene.TranslatedQuery;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.apache.solr.common.util.NamedList;
import org.z3950.zing.cql.CQLParseException;

public class SolrResultSetOptionsUtil {
    private static final Logger logger = Logger.getLogger(SolrResultSetOptionsUtil.class);

    public static NamedList<String> extractQueryOptions(String eprQuery) throws CQLParseException, IOException, SearchServiceException {
        CqlTranslatorImpl translator = new CqlTranslatorImpl();
        NamedList queryOpts = new NamedList();
        String query = null;
        boolean refineSummary = false;
        String[] sortParts = eprQuery.split("&sort=");
        String[] refineSummaryMode = sortParts[0].split("&minRef=");
        String[] queryParts = eprQuery.split("&groupby=");
        if (refineSummaryMode != null) {
            if (refineSummaryMode.length > 1 && refineSummaryMode[1].equals("true")) {
                refineSummary = true;
            }
            query = refineSummaryMode[0].replace("query=", "");
        }
        TranslatedQuery translatedQuery = null;
        try {
            translatedQuery = translator.getTranslatedQuery(query);
        }
        catch (RuntimeException re) {
            throw new SearchServiceException("Malformed Query " + query + ". " + re.getMessage());
        }
        queryOpts.add("q", (Object)translatedQuery.asLucene());
        queryOpts.add("shards.tolerant", (Object)"true");
        if (sortParts != null && sortParts.length > 1) {
            String[] sortPhrases;
            int end;
            String sortOption;
            for (String string : sortParts) {
            }
            if (sortParts[1] != null && (sortOption = sortParts[1].substring(0, end = sortParts[1].indexOf("&groupby"))) != null && sortOption.length() > 1 && (sortPhrases = sortOption.split(",")) != null && sortPhrases.length > 0) {
                StringBuilder sortPart = new StringBuilder();
                for (String sortPhrase : sortPhrases) {
                    String[] sortMembers = sortPhrase.split("/");
                    if (!sortPart.toString().isEmpty()) {
                        sortPart.append(", ");
                    }
                    if (sortMembers == null) continue;
                    if (sortMembers[1].equals("sort.ascending")) {
                        sortPart.append(sortMembers[0].trim() + " asc");
                        continue;
                    }
                    if (!sortMembers[1].equals("sort.descending")) continue;
                    sortPart.append(sortMembers[0].trim() + " desc");
                }
                queryOpts.add("sort", (Object)sortPart.toString());
            }
        }
        if (queryParts.length > 1) {
            String[] facetParts = queryParts[1].split("&fq=");
            logger.debug((Object)("facet parts" + Arrays.asList(facetParts)));
            String[] refineParts = null;
            String[] refineFields = null;
            String[] specialFacets = null;
            String[] facetQueries = null;
            if (facetParts != null && facetParts.length > 0) {
                if (!facetParts[0].isEmpty()) {
                    refineParts = facetParts[0].split("&sf=");
                    logger.debug((Object)("refine parts " + Arrays.asList(refineParts)));
                    if (refineParts != null && refineParts.length > 0) {
                        refineFields = refineParts[0].split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                    }
                    if (refineParts.length > 1) {
                        refineParts[1].replace("&sf=", "");
                        specialFacets = refineParts[1].split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                    }
                }
                if (facetParts.length > 1) {
                    facetQueries = facetParts[1].split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                }
            }
            if (refineFields != null && refineFields.length > 0) {
                queryOpts.add("facet", (Object)"true");
                queryOpts.add("facet.mincount", (Object)"1");
                queryOpts.add("facet.threads", (Object)(refineFields.length + ""));
                for (String field : refineFields) {
                    queryOpts.add("facet.field", (Object)field);
                    if (specialFacets != null && specialFacets.length != 0 && (specialFacets == null || Arrays.asList(specialFacets).contains(field))) continue;
                    queryOpts.add("f." + field + ".facet.limit", (Object)(refineSummary ? "7" : "100"));
                }
            }
            if (specialFacets != null && specialFacets.length > 0) {
                for (String field : specialFacets) {
                    queryOpts.add("f." + field + ".facet.limit", (Object)"-1");
                }
            }
            if (facetQueries != null && facetQueries.length > 0) {
                for (String facetPart : facetQueries) {
                    logger.debug((Object)("facet Part " + facetPart));
                    queryOpts.add("fq", (Object)translator.toLucene(facetPart));
                }
            }
        }
        return queryOpts;
    }
}

