/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.utils.vocabulary;

import eu.dnetlib.data.search.transform.config.Configuration;
import eu.dnetlib.data.search.utils.vocabulary.ISVocabularyLoader;
import eu.dnetlib.data.search.utils.vocabulary.IndexVocabularyLoader;
import eu.dnetlib.data.search.utils.vocabulary.LocalVocabularyLoader;
import eu.dnetlib.data.search.utils.vocabulary.Vocabulary;
import eu.dnetlib.data.search.utils.vocabulary.VocabularyLoader;
import eu.dnetlib.data.search.utils.vocabulary.VocabularyManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VocabularyManagerImpl
implements VocabularyManager {
    private Configuration config = null;
    private Map<String, VocabularyLoader> vocabularyLoaderMap = new HashMap<String, VocabularyLoader>();
    private Map<String, String> underCreation = new HashMap<String, String>();
    private Map<String, Vocabulary> vocabularyMap = new HashMap<String, Vocabulary>();
    private Map<String, Map<Locale, eu.dnetlib.domain.enabling.Vocabulary>> pathMap = new HashMap<String, Map<Locale, eu.dnetlib.domain.enabling.Vocabulary>>();
    private List<String> indexVocabularies = new ArrayList<String>();
    private ISVocabularyLoader isVocabularyLoader;
    private IndexVocabularyLoader indexVocabularyLoader;
    private LocalVocabularyLoader localVocabularyLoader;
    private static Logger logger = Logger.getLogger(VocabularyManagerImpl.class);

    public void init() {
        for (String vocabularyName : this.config.getIsVocabularyMap().keySet()) {
            this.vocabularyLoaderMap.put(vocabularyName, this.isVocabularyLoader);
            this.vocabularyMap.put(vocabularyName, this.config.getIsVocabularyMap().get(vocabularyName));
        }
        for (String vocabularyName : this.config.getIndexVocabularyMap().keySet()) {
            this.vocabularyLoaderMap.put(vocabularyName, this.indexVocabularyLoader);
            this.vocabularyMap.put(vocabularyName, this.config.getIndexVocabularyMap().get(vocabularyName));
            this.indexVocabularies.add(vocabularyName);
        }
        for (String vocabularyName : this.config.getLocalVocabularyMap().keySet()) {
            this.vocabularyLoaderMap.put(vocabularyName, this.localVocabularyLoader);
            this.vocabularyMap.put(vocabularyName, this.config.getLocalVocabularyMap().get(vocabularyName));
        }
    }

    @Override
    public String translate(String name, String l, String encoding, String default_value) {
        Locale locale = new Locale(l);
        eu.dnetlib.domain.enabling.Vocabulary vocabulary = this.getVocabulary(name, locale);
        if (vocabulary == null) {
            return default_value.length() == 0 ? encoding : default_value;
        }
        String term = vocabulary.getEnglishName(encoding);
        if (term != null && !term.trim().isEmpty()) {
            return term;
        }
        vocabulary = this.getVocabulary(name, this.config.getDefaultLocale());
        if (vocabulary == null) {
            return default_value.length() == 0 ? encoding : default_value;
        }
        term = vocabulary.getEnglishName(encoding);
        if (term != null && !term.trim().isEmpty()) {
            return term;
        }
        return default_value.length() == 0 ? encoding : default_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public eu.dnetlib.domain.enabling.Vocabulary getVocabulary(String vocabularyName, Locale locale) {
        Vocabulary vocabulary;
        eu.dnetlib.domain.enabling.Vocabulary myVocabulary = null;
        VocabularyLoader vocabularyLoader = this.vocabularyLoaderMap.get(vocabularyName);
        if (vocabularyLoader == null) {
            return null;
        }
        if (!this.config.getLocales().contains(locale)) {
            locale = this.config.getDefaultLocale();
        }
        if (this.indexVocabularies.contains(vocabularyName)) {
            locale = this.config.getDefaultLocale();
        }
        if ((vocabulary = this.vocabularyMap.get(vocabularyName)) == null) {
            return null;
        }
        Map<Locale, eu.dnetlib.domain.enabling.Vocabulary> localePathMap = this.pathMap.get(vocabularyName);
        try {
            if (localePathMap == null) {
                localePathMap = new HashMap<Locale, eu.dnetlib.domain.enabling.Vocabulary>();
            }
            if (this.underCreation.get(vocabularyName + locale) == null) {
                this.underCreation.put(vocabularyName + locale, "");
                myVocabulary = vocabularyLoader.loadVocabulary(vocabulary, locale);
                localePathMap.put(locale, myVocabulary);
                this.pathMap.put(vocabularyName, localePathMap);
            } else {
                myVocabulary = localePathMap.get(locale);
                if (myVocabulary == null && this.underCreation.get(vocabularyName + locale) == null) {
                    this.underCreation.put(vocabularyName + locale, "");
                    myVocabulary = vocabularyLoader.loadVocabulary(vocabulary, locale);
                    localePathMap.put(locale, myVocabulary);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Cannot load vocabulary " + vocabularyName + locale), (Throwable)e);
        }
        finally {
            if (this.underCreation.get(vocabularyName + locale) != null && !this.underCreation.get(vocabularyName + locale).isEmpty()) {
                this.underCreation.put(vocabularyName + locale, null);
            }
        }
        return myVocabulary;
    }

    @Override
    public eu.dnetlib.domain.enabling.Vocabulary getVocabulary(String vocabularyName, Locale locale, boolean loadanyway) {
        Vocabulary vocabulary;
        eu.dnetlib.domain.enabling.Vocabulary myVocabulary = null;
        VocabularyLoader vocabularyLoader = this.vocabularyLoaderMap.get(vocabularyName);
        if (vocabularyLoader == null) {
            return null;
        }
        if (!this.config.getLocales().contains(locale)) {
            locale = this.config.getDefaultLocale();
        }
        if (this.indexVocabularies.contains(vocabularyName)) {
            locale = this.config.getDefaultLocale();
        }
        if ((vocabulary = this.vocabularyMap.get(vocabularyName)) == null) {
            return null;
        }
        Map<Locale, eu.dnetlib.domain.enabling.Vocabulary> localePathMap = this.pathMap.get(vocabularyName);
        try {
            if (localePathMap == null) {
                localePathMap = new HashMap<Locale, eu.dnetlib.domain.enabling.Vocabulary>();
                myVocabulary = vocabularyLoader.loadVocabulary(vocabulary, locale);
                localePathMap.put(locale, myVocabulary);
                this.pathMap.put(vocabularyName, localePathMap);
            } else {
                myVocabulary = localePathMap.get(locale);
                if (myVocabulary == null || loadanyway) {
                    myVocabulary = vocabularyLoader.loadVocabulary(vocabulary, locale);
                    localePathMap.put(locale, myVocabulary);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Cannot load vocabulary " + vocabularyName + " with locale " + locale), (Throwable)e);
        }
        return myVocabulary;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public void setIsVocabularyLoader(ISVocabularyLoader isVocabularyLoader) {
        this.isVocabularyLoader = isVocabularyLoader;
    }

    public void setIndexVocabularyLoader(IndexVocabularyLoader indexVocabularyLoader) {
        this.indexVocabularyLoader = indexVocabularyLoader;
    }

    public void setLocalVocabularyLoader(LocalVocabularyLoader localVocabularyLoader) {
        this.localVocabularyLoader = localVocabularyLoader;
    }

    public Map<String, Vocabulary> getVocabulariesMap() {
        return this.vocabularyMap;
    }

    @Override
    public Set<String> getVocabularyNames() {
        return this.vocabularyMap.keySet();
    }

    @Override
    public List<Locale> getLocales() {
        return this.config.getLocales();
    }
}

