/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.web.api;

import eu.dnetlib.data.search.web.api.Error;
import eu.dnetlib.data.search.web.api.SearchRequestController;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@EnableWebMvc
@ControllerAdvice(value={"eu.dnetlib.data.search.web.api"}, assignableTypes={SearchRequestController.class})
public class ExceptionController
extends ResponseEntityExceptionHandler {
    @Autowired
    PrometheusMeterRegistry registry;

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Error> invalidInput(Exception ex) {
        Error response = new Error();
        response.setStatus("error");
        response.setCode("500");
        response.setMessage(ex.getMessage());
        response.setException(ex.getCause().getMessage());
        this.registry.counter("http.status.500", new String[]{"500", "uri"}).increment();
        return new ResponseEntity((Object)response, HttpStatus.CONFLICT);
    }
}

