
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:oaf="http://namespace.openaire.eu/oaf"
                xmlns:dc="http://purl.org/dc/elements/1.1/">

    <!-- Turn off auto-insertion of <?xml> tag and set indenting on -->
    <xsl:output method="text" encoding="utf-8" omit-xml-declaration="yes" media-type="text/csv" />

    <!-- strip whitespace from whitespace-only nodes -->
    <xsl:strip-space elements="*"/>

    <xsl:variable name="apos">'</xsl:variable>

    <xsl:template match = "/">
        <xsl:apply-templates select="//oaf:result"/>
    </xsl:template>

    <xsl:template match="text()">
        <xsl:value-of select="replace(., '[&#x007F;-&#x009F;]', ' ')"/>
    </xsl:template>

    <!-- (old) Type, Title, Authors, Publication Year, DOI, Download from, Publication Type, Journal, Funder, Project Name (GA Number), Access -->
    <!-- Type,Title,Authors,Publication Year,DOI,Type,Peer Reviewed,Diamond Journal,Journal,Download from,Publicly Funded,Funder|Project Name (GA Number),Access,Green,OA colour -->

    <xsl:template match="oaf:result">
        <xsl:for-each select="rels/rel/to[@class='isProducedBy']">
            <!-- Type -->
            <xsl:value-of select="../../../resulttype/@classname"/>
            <xsl:text>,</xsl:text>

            <!-- Title -->
            <xsl:text>"</xsl:text>
            <xsl:call-template name="escape-quot-string">
                <xsl:with-param name="s" select="../../../title"/>
            </xsl:call-template>
            <xsl:text>",</xsl:text>

            <!-- Authors -->
            <xsl:text>"</xsl:text>
            <xsl:for-each select="../../../creator">
                <xsl:sort select="@rank"/>
            <xsl:call-template name="escape-quot-string">
                <xsl:with-param name="s" select="."/>
            </xsl:call-template>
                <xsl:if test="not(position()=last())">
                    <xsl:text>;</xsl:text>
                </xsl:if>
            </xsl:for-each>
            <xsl:text>"</xsl:text>
            <xsl:text>,</xsl:text>
            
            <!-- Publication Year -->
            <xsl:value-of select="../../../dateofacceptance"/>
            <xsl:text>,</xsl:text>

            <!-- DOI -->
            <xsl:for-each select="../../../pid[@classid='doi']">
                <xsl:value-of select="."/>
                <xsl:if test="not(position()=last())">
                    <xsl:text>;</xsl:text>
                </xsl:if>
            </xsl:for-each>
            <xsl:text>,</xsl:text>

            <!-- Publication Type -->
	    <xsl:text>"</xsl:text>
            <xsl:value-of select="../../../children/instance[1]/instancetype/@classname"/>
	    <xsl:text>"</xsl:text>
            <xsl:text>,</xsl:text>

        <!-- Peer Reviewed -->
        <xsl:choose>
            <xsl:when test="count(../../..//instance/refereed[@classid='0001']) > 0">
                <xsl:text>yes</xsl:text>
                <xsl:text>,</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="../../..//instance[1]"/>
            </xsl:otherwise>
        </xsl:choose>

	    <!-- Diamond Journal-->
	    <xsl:if test="../../../isindiamondjournal and ../../../isindiamondjournal='true'">
	    	<xsl:text>yes</xsl:text>
	    </xsl:if>
	    <xsl:if test="../../../isindiamondjournal and ../../../isindiamondjournal='false'">
	    	<xsl:text>no</xsl:text>
	    </xsl:if>
	   <xsl:text>,</xsl:text>

            <!-- Journal -->
            <xsl:text>"</xsl:text>
            <xsl:call-template name="escape-quot-string">
                <xsl:with-param name="s"  select="replace(../../../source, '&lt;/?\w+[^&lt;]*&gt;', '')"/>
            </xsl:call-template>
            <xsl:text>",</xsl:text>

            <!-- Download from -->
            <xsl:value-of select="../../../children/instance[1]/webresource[1]"/>
            <xsl:text>,</xsl:text>

        <!-- Publicly Funded -->
        <xsl:if test="../../../publiclyfunded and ../../../publiclyfunded='true'">
            <xsl:text>yes</xsl:text>
        </xsl:if>
        <xsl:if test="../../../publiclyfunded and ../../../publiclyfunded='false'">
            <xsl:text>no</xsl:text>
        </xsl:if>
        <xsl:text>,</xsl:text>

            <!-- Funder -->
            <xsl:value-of select="../funding/funder/@name"/>
            <xsl:text>(</xsl:text>
            <xsl:value-of select="../funding/funder/@shortname"/>
            <xsl:text>),</xsl:text>

            <!-- Project Name (GA Number) -->
            <xsl:choose>
                <xsl:when test="../acronym">
                    <xsl:value-of select="../acronym"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>"</xsl:text>
                    <xsl:value-of select="../title"/>
                    <xsl:text>"</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:text>(</xsl:text>
            <xsl:value-of select="../code"/>
            <xsl:text>),</xsl:text>

            <!-- Access -->
            <xsl:value-of select="../../../bestaccessright/@classname"/>
	    <xsl:text>,</xsl:text>

        <!-- Green -->
        <xsl:if test="../../../isgreen and ../../../isgreen='true'">
            <xsl:text>yes</xsl:text>
        </xsl:if>
        <xsl:if test="../../../isgreen and ../../../isgreen='false'">
            <xsl:text>no</xsl:text>
        </xsl:if>
        <xsl:text>,</xsl:text>

        <!-- OA colour -->
        <xsl:value-of select="openaccesscolor"/>

         <xsl:text>&#xD;</xsl:text>
	 <xsl:text>&#xA;</xsl:text>

        </xsl:for-each>

    </xsl:template>

    <xsl:template name="escape-quot-string">
        <xsl:param name="s"/>
        <xsl:choose>
            <xsl:when test="contains($s,'&quot;')">
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="concat(substring-before($s,'&quot;'),$apos)"/>
                </xsl:call-template>
                <xsl:call-template name="escape-quot-string">
                    <xsl:with-param name="s" select="substring-after($s,'&quot;')"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="$s"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="encode-string">
        <xsl:param name="s"/>
        <xsl:choose>
            <!-- tab -->
            <xsl:when test="contains($s,'&#x9;')">
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="concat(substring-before($s,'&#x9;'),'\t',substring-after($s,'&#x9;'))"/>
                </xsl:call-template>
            </xsl:when>
            <!-- line feed -->
            <xsl:when test="contains($s,'&#xA;')">
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="concat(substring-before($s,'&#xA;'),'\n',substring-after($s,'&#xA;'))"/>
                </xsl:call-template>
            </xsl:when>
            <!-- carriage return -->
            <xsl:when test="contains($s,'&#xD;')">
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="concat(substring-before($s,'&#xD;'),'\r',substring-after($s,'&#xD;'))"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="$s"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="instance" match="//instance[1]">
        <xsl:if test="./refereed[@classid='0000']">
            <xsl:text>,</xsl:text>
        </xsl:if>
        <xsl:if test="./refereed[@classid='0002']">
            <xsl:text>no</xsl:text>
            <xsl:text>,</xsl:text>
        </xsl:if>
        <xsl:if test="not(./refereed)">
            <xsl:text>,</xsl:text>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
