<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:dri="http://www.driver-repository.eu/namespace/dri"
				xmlns:oaf="http://namespace.openaire.eu/oaf"
				xmlns:dc="http://purl.org/dc/elements/1.1/">
	<xsl:output method="xml" indent="yes" encoding="UTF-8"/>

	<xsl:template match = "/">
		<response>
			<xsl:apply-templates select="response/header"/>
			<publications>
				<xsl:apply-templates select="/result"/>
			</publications>
		</response>
	</xsl:template>

	<xsl:template match="response/header">
		<header>
			<size><xsl:value-of select="size"/></size>
			<page><xsl:value-of select="page"/></page>
			<total><xsl:value-of select="total"/></total>
		</header>
	</xsl:template>

	<xsl:template match="result">
		<publication>
			<xsl:apply-templates select="//header"/>
			<xsl:apply-templates select="//oaf:result"/>
		</publication>
	</xsl:template>

	<!-- HEADER
    fields in header:
    1. dri:objIdentifier 		[objIdentifier]
    2. dri:repositoryId			X
    3. dri:dateOfCollection		X
    -->

	<xsl:template match="text()">
		<xsl:value-of select="replace(., '[&#x007F;-&#x009F;]', ' ')"/>
	</xsl:template>

	<xsl:template match = "header">
		<openaireid>
			<xsl:value-of select='./dri:objIdentifier'/>
		</openaireid>
	</xsl:template>

	<xsl:template name="refereed" match="//instance/refereed[@classid='0001'][1]">
		<peerReviewed>true</peerReviewed>
		<publicationtype><xsl:value-of select="../instancetype/@classname"/></publicationtype>
		<pid_published>
			<xsl:attribute name="type">
				<xsl:value-of select="../pid/@classid"/>
			</xsl:attribute>
			<xsl:value-of select="../pid"/>
		</pid_published>
		<license><xsl:value-of select="../license"/></license>
	</xsl:template>

	<xsl:template name="instance" match="//instance[1]">
		<xsl:if test="./refereed[@classid='0000']">
			<peerReviewed/>
		</xsl:if>
		<xsl:if test="./refereed[@classid='0002']">
			<peerReviewed>false</peerReviewed>
		</xsl:if>
		<xsl:if test="not(./refereed)">
			<peerReviewed/>
		</xsl:if>
		<publicationtype><xsl:value-of select="./instancetype/@classname"/></publicationtype>
		<license><xsl:value-of select="./license"/></license>
	</xsl:template>


	<xsl:template match = "oaf:result">

		<pids>
			<xsl:for-each select = "./pid">
				<xsl:choose>
					<xsl:when test="./@classid='doi'">
						<doi>
							<xsl:value-of select='.'/>
						</doi>
					</xsl:when>
					<xsl:when test="./@classid='handle'">
						<handle>
							<xsl:value-of select='.'/>
						</handle>
					</xsl:when>
					<xsl:when test="./@classidtest!= ''">
						<other>
							<xsl:attribute name="type">
								<xsl:value-of select="./@classid"/>
							</xsl:attribute>
							<xsl:value-of select='.'/>
						</other>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</pids>

		<xsl:choose>
			<xsl:when test="count(//instance/refereed[@classid='0001']) > 0">
				<xsl:for-each select="(//instance/refereed[@classid='0001'])[1]">
					<peerReviewed>true</peerReviewed>
					<publicationtype><xsl:value-of select="../instancetype/@classname"/></publicationtype>
					<pid_published>
						<xsl:attribute name="type">
							<xsl:value-of select="../pid/@classid"/>
						</xsl:attribute>
						<xsl:value-of select="../pid"/>
					</pid_published>
					<license><xsl:value-of select="../license"/></license>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="//instance[1]"/>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:for-each select = "./title">
			<title><xsl:value-of select='.'/></title>
		</xsl:for-each>

		<authors>
			<?xml-multiple?>
			<xsl:for-each select="./creator">
				<xsl:sort select="./@rank"/>
				<author>
					<xsl:if test="./@orcid">
						<xsl:attribute name="orcid">
							<xsl:value-of select='./@orcid'/>
						</xsl:attribute>
					</xsl:if>
					<xsl:value-of select='.'/>
				</author>
			</xsl:for-each>
		</authors>

		<xsl:for-each select = "./description">
			<description>
				<xsl:value-of select='.'/>
			</description>
		</xsl:for-each>

		<xsl:for-each select = "./journal">
			<journal>
				<name><xsl:value-of select="."/></name>
				<issn><xsl:value-of select="./@issn"/></issn>
				<eissn><xsl:value-of select="./@eissn"/></eissn>
				<lissn><xsl:value-of select="./@lissn"/></lissn>
				<issue><xsl:value-of select="./@iss"/></issue>
				<volume><xsl:value-of select="./@vol"/></volume>
			</journal>
		</xsl:for-each>

		<publisher>
			<xsl:value-of select = "./publisher"/>
		</publisher>

		<dateofacceptance>
			<xsl:value-of select = "./dateofacceptance"/>
		</dateofacceptance>

		<xsl:for-each select="./children/instance/webresource">
			<webresource><xsl:value-of select="url"/></webresource>
		</xsl:for-each>

		<bestaccessright>
			<xsl:value-of select="./bestaccessright/@classid"/>
		</bestaccessright>

		<embargoenddate>
			<xsl:value-of select="./embargoenddate"/>
		</embargoenddate>

		<processingchargeamount>
			<xsl:value-of select="./processingchargeamount"/>
		</processingchargeamount>

		<processingchargecurrency>
			<xsl:value-of select="./processingchargecurrency"/>
		</processingchargecurrency>

	</xsl:template>

</xsl:stylesheet>


