<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns="http://namespace.openaire.eu/sygma">
    <xsl:output method="xml" indent="yes" encoding="UTF-8"/>

    <xsl:template match = "/">
        <response>
            <xsl:apply-templates select="response/header"/>
            <publications>
                <xsl:apply-templates select="response/results/response/publications"/>
            </publications>
        </response>
    </xsl:template>

    <xsl:template match="response/header">
        <header>
            <query><xsl:value-of select="query"/></query>
            <size><xsl:value-of select="size"/></size>
            <page><xsl:value-of select="page"/></page>
            <total><xsl:value-of select="total"/></total>
        </header>
    </xsl:template>


    <xsl:template match="response/results/response/publications">
        <xsl:apply-templates mode="copy-no-namespaces"/>
    </xsl:template>

    <xsl:template match="*" mode="copy-no-namespaces">
        <xsl:element name="{local-name()}">
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="node()" mode="copy-no-namespaces"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="comment()| processing-instruction()" mode="copy-no-namespaces">
        <xsl:copy/>
    </xsl:template>



</xsl:stylesheet>