<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:oaf="http://namespace.openaire.eu/oaf"
                xmlns:dc="http://purl.org/dc/elements/1.1/">
    <xsl:output method="xml" indent="yes" encoding="UTF-8"/>

    <xsl:template match = "/">
        <response>
            <xsl:apply-templates select="response/header"/>
            <datasets>
                <xsl:apply-templates select="/result"/>
            </datasets>
        </response>
    </xsl:template>

    <xsl:template match="response/header">
        <header>
            <size><xsl:value-of select="size"/></size>
            <page><xsl:value-of select="page"/></page>
            <total><xsl:value-of select="total"/></total>
        </header>
    </xsl:template>

    <xsl:template match="result">
        <dataset>
            <xsl:apply-templates select="//header"/>
            <xsl:apply-templates select="//oaf:result"/>
        </dataset>
    </xsl:template>

    <!-- HEADER
    fields in header:
    1. dri:objIdentifier 		[objIdentifier]
    2. dri:repositoryId			X
    3. dri:dateOfCollection		X
    -->

    <xsl:template match="text()">
        <xsl:value-of select="replace(., '[&#x007F;-&#x009F;]', ' ')"/>
    </xsl:template>

    <xsl:template match = "header">
        <openaireid>
            <xsl:value-of select='./dri:objIdentifier'/>
        </openaireid>
    </xsl:template>


    <xsl:template match = "oaf:result">

        <pids>
            <xsl:for-each select = "./pid">
                <xsl:choose>
                    <xsl:when test="./@classid='doi'">
                        <doi>
                            <xsl:value-of select='.'/>
                        </doi>
                    </xsl:when>
                    <xsl:when test="./@classid='handle'">
                        <handle>
                            <xsl:value-of select='.'/>
                        </handle>
                    </xsl:when>
                    <xsl:when test="./@classidtest!= ''">
                        <other>
                            <xsl:attribute name="type">
                                <xsl:value-of select="./@classid"/>
                            </xsl:attribute>
                            <xsl:value-of select='.'/>
                        </other>
                    </xsl:when>
                </xsl:choose>
            </xsl:for-each>
        </pids>

        <xsl:for-each select = "./title">
            <title><xsl:value-of select='.'/></title>
        </xsl:for-each>

        <authors>
            <xsl:for-each select="./creator">
                <xsl:sort select="./@rank"/>
                <author>
                    <xsl:if test="./@orcid">
                        <xsl:attribute name="orcid">
                            <xsl:value-of select='./@orcid'/>
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:value-of select='.'/>
                </author>
            </xsl:for-each>
        </authors>

        <xsl:for-each select = "./description">
            <description>
                <xsl:value-of select='.'/>
            </description>
        </xsl:for-each>

        <xsl:for-each select="./children/instance/webresource">
            <webresource><xsl:value-of select="url"/></webresource>
        </xsl:for-each>

        <bestaccessright>
            <xsl:value-of select="./bestaccessright/@classid"/>
        </bestaccessright>

        <license>
            <xsl:value-of select="./children/instance[1]/license"/>
        </license>

        <relatedpublications>
            <xsl:apply-templates select="rels/rel/to[@type='publication']"/>
        </relatedpublications>

    </xsl:template>

    <xsl:template match="rels/rel/to[@type='publication']">
        <publication>
            <openaireid><xsl:value-of select="."/></openaireid>
            <doi><xsl:value-of select="../pid[@classid='doi']"/></doi>
            <title><xsl:value-of select="../title"/></title>
            <authors></authors>
            <sourcejournal></sourcejournal>
            <publisher><xsl:value-of select="../publisher"/></publisher>
            <dateofacceptance><xsl:value-of select="../dateofacceptance"/></dateofacceptance>
            <webresource></webresource>
            <bestaccessright></bestaccessright>
        </publication>
    </xsl:template>
</xsl:stylesheet>
