<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

    <!-- Turn off auto-insertion of <?xml> tag and set indenting on -->
    <xsl:output method="text" encoding="utf-8" omit-xml-declaration="yes" media-type="text/csv" />

    <!-- strip whitespace from whitespace-only nodes -->
    <xsl:strip-space elements="*"/>

    <xsl:variable name="apos">'</xsl:variable>

    <xsl:template match = "/">
        <xsl:text disable-output-escaping="yes">Title&#x9;Authors&#x9;Publication Year&#x9;DOI&#x9;Download From&#x9;Publication type&#x9;Journal&#x9;Funder&#x9;Project Name (GA Number)&#x9;Access&#xD;</xsl:text>
        <xsl:apply-templates select="//result"/>
    </xsl:template>

    <!-- Title&#x9; Authors&#x9; Description&#x9; Year&#x9; DOI&#x9; Permanent identifier&#x9; Download From&#x9; Journal&#x9; Project Name&#x9; GA number&#x9; Access -->
    <xsl:template match="result">
        <xsl:choose>
            <xsl:when test="field[@name='project']">
                <xsl:for-each select="field[@name='project']">
                    <!-- title -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:value-of select="../field[@name='title']/@value"/>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>&#x9;</xsl:text>

                    <!-- authors -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:for-each select="../field[@name='hasAuthor']">
                        <xsl:sort select="field[@name='ranking']/@value" data-type="number"/>
                        <xsl:value-of select="field[@name='fullname']/@value"/>
                        <xsl:if test="not(position()=last())">
                            <xsl:text>;</xsl:text>
                        </xsl:if>
                    </xsl:for-each>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>&#x9;</xsl:text>

                    <!-- description
                    <xsl:text>&quot;</xsl:text>
                        <xsl:value-of select="field[@name='description']/@value"/>
                        <xsl:if test="position() != last()"><xsl:text>&#160;</xsl:text></xsl:if>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>&#x9;</xsl:text>
            -->
                    <!-- year -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:value-of select="../field[@name='dateofacceptance']/@value"/>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>&#x9;</xsl:text>

                    <!-- DOI -->
                    <xsl:for-each select="../field[@name='pid']">
                        <xsl:if test="field[@name='classid' and @value='doi']/@value = 'doi'">
                            <xsl:text>&quot;</xsl:text>
                            <xsl:value-of select="field[@name='value']/@value"/>
                            <xsl:text>&quot;</xsl:text>
                        </xsl:if>
                    </xsl:for-each>
                    <xsl:text>&#x9;</xsl:text>

                    <!-- Permanent Identifier -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:value-of select="../field[@name='datasource'][1]/field[@name='url']/@value"/>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>&#x9;</xsl:text>

                    <!-- Publication type -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:value-of select="../field[@name='datasource'][1]/field[@name='typename']/@value"/>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>&#x9;</xsl:text>

                    <!-- journal -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:for-each select="../field[@name='source']">
                        <xsl:call-template name="escape-quot-string">
                            <xsl:with-param name="s"  select="replace(@value, '&lt;/?\w+[^&lt;]*&gt;', '')"/>
                        </xsl:call-template>
                    </xsl:for-each>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>&#x9;</xsl:text>

                    <!-- Funder -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:for-each select="field[@name='funding']/field[@name='funder']">
                        <xsl:value-of select="@value"/>
                    </xsl:for-each>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>&#x9;</xsl:text>

                    <!-- project name -->
                    <xsl:text>&quot;</xsl:text>
                    <!-- project name -->
                    <xsl:choose>
                        <xsl:when test="field[@name='projectacronym']/@value != ''" >
                            <xsl:value-of select="field[@name='projectacronym']/@value"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="field[@name='projecttitle']/@value"/>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:if test="field[@name='projectcode']/@value!= ''">
                        <xsl:value-of select="concat('(',field[@name='projectcode']/@value,')')"/>
                    </xsl:if>

                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>&#x9;</xsl:text>

                    <!--access -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:value-of select="../field[@name='bestaccessright']/@value"/>
                    <xsl:text>&quot;</xsl:text>
                     <xsl:text>&#xD;</xsl:text>
 <xsl:text>&#xA;</xsl:text>

                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <!-- title -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="field[@name='title']/@value"/>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>&#x9;</xsl:text>

                <!-- authors -->
                <xsl:text>&quot;</xsl:text>
                <xsl:for-each select="field[@name='hasAuthor']">
                    <xsl:value-of select="field[@name='fullname']/@value"/>
                    <xsl:if test="not(position()=last())">
                        <xsl:text>;</xsl:text>
                    </xsl:if>
                </xsl:for-each>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>&#x9;</xsl:text>

                <!-- year -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="field[@name='dateofacceptance']/@value"/>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>&#x9;</xsl:text>

                <!-- DOI -->
                <xsl:for-each select="field[@name='pid']">
                    <xsl:if test="field[@name='classid' and @value='doi']/@value = 'doi'">
                        <xsl:text>&quot;</xsl:text>
                        <xsl:value-of select="field[@name='value']/@value"/>
                        <xsl:text>&quot;</xsl:text>
                    </xsl:if>
                </xsl:for-each>
                <xsl:text>&#x9;</xsl:text>

                <!-- Download From -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="field[@name='datasource'][1]/field[@name='url']/@value"/>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>&#x9;</xsl:text>

                <!-- Publication type -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="field[@name='datasource'][1]/field[@name='typename']/@value"/>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>&#x9;</xsl:text>

                <!-- journal -->
                <xsl:text>&quot;</xsl:text>
                <xsl:for-each select="field[@name='source']">
                    <xsl:call-template name="escape-quot-string">
                        <xsl:with-param name="s"  select="replace(@value, '&lt;/?\w+[^&lt;]*&gt;', '')"/>
                    </xsl:call-template>
                </xsl:for-each>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>&#x9;</xsl:text>

                <!-- Funder -->
                <xsl:text>&quot;</xsl:text>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>&#x9;</xsl:text>

                <!-- project name -->
                <xsl:text>&quot;</xsl:text>
                <!-- project name -->
                <xsl:text>&quot;</xsl:text>
                <xsl:text>&#x9;</xsl:text>

                <!--access -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="../field[@name='bestaccessright']/@value"/>
                <xsl:text>&quot;</xsl:text>
                 <xsl:text>&#xD;</xsl:text>
 <xsl:text>&#xA;</xsl:text>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <xsl:template name="escape-quot-string">
        <xsl:param name="s"/>
        <xsl:choose>
            <xsl:when test="contains($s,'&quot;')">
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="concat(substring-before($s,'&quot;'),$apos)"/>
                </xsl:call-template>
                <xsl:call-template name="escape-quot-string">
                    <xsl:with-param name="s" select="substring-after($s,'&quot;')"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="$s"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="encode-string">
        <xsl:param name="s"/>
        <xsl:choose>
            <!-- tab -->
            <xsl:when test="contains($s,'&#x9;')">
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="concat(substring-before($s,'&#x9;'),'\t',substring-after($s,'&#x9;'))"/>
                </xsl:call-template>
            </xsl:when>
            <!-- line feed -->
            <xsl:when test="contains($s,'&#xA;')">
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="concat(substring-before($s,'&#xA;'),'\n',substring-after($s,'&#xA;'))"/>
                </xsl:call-template>
            </xsl:when>
            <!-- carriage return -->
            <xsl:when test="contains($s,'&#xD;')">
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="concat(substring-before($s,'&#xD;'),'\r',substring-after($s,'&#xD;'))"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="$s"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>