/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.controllers;

import eu.dnetlib.uoausermanagment.configuration.Properties;
import eu.dnetlib.uoausermanagment.services.HttpService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@Profile(value={"html"})
public class DeprecatedController {
    private final String developers;
    private final String developersApi;
    private final HttpService httpService;

    @Autowired
    public DeprecatedController(Properties properties, HttpService httpService) {
        this.developers = properties.getDevelopers();
        this.developersApi = properties.getDevelopersApi();
        this.httpService = httpService;
    }

    @GetMapping(value={"/{page}.jsp"})
    public String deprecatedPages(@PathVariable(value="page") String page) {
        switch (page) {
            case "requestActivationCode": {
                page = "request-code";
                break;
            }
            case "404": {
                page = "error";
                break;
            }
            case "requestToDeleteAccount": {
                page = "request-delete-account";
                break;
            }
            case "emailConfirmation": {
                page = "email-confirmation";
                break;
            }
            case "remindUsername": {
                page = "remind-username";
                break;
            }
            case "forgotPassword": {
                page = "forgot-password";
                break;
            }
            case "resetPassword": {
                page = "reset-password";
                break;
            }
            case "verifyToDelete": {
                page = "delete-account";
            }
        }
        return "redirect:/" + page;
    }

    @GetMapping(value={"/overview"})
    public void getOverview(HttpServletResponse response) throws IOException {
        response.sendRedirect(this.developers);
    }

    @GetMapping(value={"/registerService", "/registeredServices"})
    public void getAPIs(HttpServletResponse response) throws IOException {
        response.sendRedirect(this.developers + "/apis");
    }

    @GetMapping(value={"/personalToken"})
    public void getPersonalToken(HttpServletResponse response) throws IOException {
        response.sendRedirect(this.developers + "/personal-token");
    }

    @GetMapping(value={"/api/users/getAccessToken"})
    public ResponseEntity<Object> getPersonalToken(HttpServletRequest request, @RequestParam(name="refreshToken") String refreshToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("refreshToken", refreshToken);
        return ResponseEntity.ok((Object)this.httpService.get(request, this.developersApi + "accessToken", params, Object.class));
    }
}

