/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoausermanagment.controllers;

import eu.dnetlib.uoausermanagment.configuration.Google;
import eu.dnetlib.uoausermanagment.configuration.Properties;
import eu.dnetlib.uoausermanagment.dto.form.ActivationForm;
import eu.dnetlib.uoausermanagment.dto.form.Form;
import eu.dnetlib.uoausermanagment.dto.form.RegisterForm;
import eu.dnetlib.uoausermanagment.dto.form.RequestByEmailForm;
import eu.dnetlib.uoausermanagment.dto.form.RequestByUsernameForm;
import eu.dnetlib.uoausermanagment.dto.form.ResetPasswordForm;
import eu.dnetlib.uoausermanagment.dto.form.VerificationForm;
import eu.dnetlib.uoausermanagment.entities.AccountStatus;
import eu.dnetlib.uoausermanagment.entities.User;
import eu.dnetlib.uoausermanagment.entities.UserVerification;
import eu.dnetlib.uoausermanagment.entities.ZombieUser;
import eu.dnetlib.uoausermanagment.services.LDAPService;
import eu.dnetlib.uoausermanagment.services.UserVerificationService;
import eu.dnetlib.uoausermanagment.services.ValidationService;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@Profile(value={"html"})
public class FormPageController {
    private final Google google;
    private final ValidationService validationService;
    private final UserVerificationService userVerificationService;
    private final LDAPService ldapService;

    public FormPageController(Properties properties, ValidationService validationService, UserVerificationService userVerificationService, LDAPService ldapService) {
        this.google = properties.getGoogle();
        this.validationService = validationService;
        this.userVerificationService = userVerificationService;
        this.ldapService = ldapService;
    }

    @GetMapping(value={"/register"})
    public String register(Model model) {
        RegisterForm registerForm = new RegisterForm();
        model.addAttribute("form", (Object)registerForm);
        model.addAttribute("siteKey", (Object)this.google.getKey());
        return "register";
    }

    @PostMapping(value={"/register"})
    public String register(HttpServletRequest request, Model model, RegisterForm form) {
        String path = "register";
        if (form.validate(this.ldapService, this.validationService, model, request.getParameter("g-recaptcha-response"))) {
            ZombieUser zombieUser = this.ldapService.createZombieUser(form, model);
            if (!model.containsAttribute("server_error")) {
                UserVerification verification = this.userVerificationService.create(zombieUser.getUsername());
                this.userVerificationService.sendActivationVerification(request, model, verification, zombieUser.getEmail());
                if (!model.containsAttribute("server_error")) {
                    path = "redirect:/activate";
                }
            }
        }
        return this.redirect(model, (Form)form, path);
    }

    @GetMapping(value={"/activate"})
    public String activateAccount(Model model, @RequestParam(value="code", required=false) String code) {
        model.addAttribute("form", (Object)new ActivationForm(code));
        model.addAttribute("siteKey", (Object)this.google.getKey());
        return "activate";
    }

    @PostMapping(value={"/activate"})
    public String activateAccount(HttpServletRequest request, Model model, ActivationForm form) {
        String path = "activate";
        if (form.validate(this.ldapService, this.validationService, model, request.getParameter("g-recaptcha-response")) && (path = this.userVerificationService.validate(request, model, form.getUsername(), form.getVerificationCode(), "activate")) == null) {
            String error = this.ldapService.moveUser(form.getUsername());
            if (error != null) {
                model.addAttribute("server_error", (Object)error);
                return this.redirect(model, (Form)form, "activate");
            }
            request.getSession().setAttribute("register-success", (Object)true);
            path = "redirect:/register-success";
        }
        return this.redirect(model, (Form)form, path);
    }

    @GetMapping(value={"/verify"})
    public String verifyAccount(Model model, @RequestParam(value="code", required=false) String code) {
        model.addAttribute("form", (Object)new VerificationForm(code));
        model.addAttribute("siteKey", (Object)this.google.getKey());
        return "verify";
    }

    @PostMapping(value={"/verify"})
    public String verifyAccount(HttpServletRequest request, Model model, VerificationForm form) {
        String path = "verify";
        if (form.validate(this.ldapService, this.validationService, model, request.getParameter("g-recaptcha-response")) && (path = this.userVerificationService.validate(request, model, form.getUsername(), form.getVerificationCode(), "activate")) == null) {
            request.getSession().setAttribute("username", (Object)form.getUsername());
            path = "redirect:/reset-password";
        }
        return this.redirect(model, (Form)form, path);
    }

    @GetMapping(value={"/request-code"})
    public String requestVerificationCode(Model model) {
        model.addAttribute("form", (Object)new RequestByUsernameForm());
        model.addAttribute("siteKey", (Object)this.google.getKey());
        return "request-code";
    }

    @PostMapping(value={"/request-code"})
    public String requestVerificationCode(HttpServletRequest request, Model model, RequestByUsernameForm form) {
        String path = "request-code";
        if (form.validate(this.ldapService, this.validationService, model, request.getParameter("g-recaptcha-response"))) {
            ZombieUser user = this.ldapService.getZombieUser(form.getUsername());
            UserVerification verification = this.userVerificationService.create(user.getUsername());
            this.userVerificationService.sendActivationVerification(request, model, verification, user.getEmail());
            if (!model.containsAttribute("server_error")) {
                path = "redirect:/activate";
            }
        }
        return this.redirect(model, (Form)form, path);
    }

    @GetMapping(value={"/request-delete-account"})
    public String requestDeleteAccount(Model model) {
        model.addAttribute("form", (Object)new RequestByEmailForm());
        model.addAttribute("siteKey", (Object)this.google.getKey());
        return "request-delete-account";
    }

    @PostMapping(value={"/request-delete-account"})
    public String requestDeleteAccount(HttpServletRequest request, Model model, RequestByEmailForm form) {
        String path = "request-delete-account";
        if (form.validate(this.ldapService, this.validationService, model, request.getParameter("g-recaptcha-response"))) {
            String username = this.ldapService.accountStatusByEmail(form.getEmail()).equals((Object)AccountStatus.ACTIVATED) ? this.ldapService.getUserByEmail(form.getEmail()).getUsername() : this.ldapService.getZombieUserByEmail(form.getEmail()).getUsername();
            this.userVerificationService.sendVerificationToDelete(request, model, this.userVerificationService.create(username), form.getEmail());
            if (!model.containsAttribute("server_error")) {
                path = "redirect:/delete-account";
            }
        }
        return this.redirect(model, (Form)form, path);
    }

    @GetMapping(value={"/delete-account"})
    public String deleteAccount(Model model, @RequestParam(value="code", required=false) String code) {
        model.addAttribute("form", (Object)new VerificationForm(code));
        model.addAttribute("siteKey", (Object)this.google.getKey());
        return "delete-account";
    }

    @PostMapping(value={"/delete-account"})
    public String deleteAccount(HttpServletRequest request, Model model, VerificationForm form) {
        String path = "delete-account";
        if (form.validate(this.ldapService, this.validationService, model, request.getParameter("g-recaptcha-response")) && (path = this.userVerificationService.validate(request, model, form.getUsername(), form.getVerificationCode(), "activate")) == null) {
            String error = this.ldapService.deleteUser(form.getUsername());
            if (error != null) {
                model.addAttribute("server_error", (Object)error);
                return this.redirect(model, (Form)form, "delete-account");
            }
            request.getSession().setAttribute("delete-success", (Object)true);
            path = "redirect:/delete-success";
        }
        return this.redirect(model, (Form)form, path);
    }

    @GetMapping(value={"/remind-username"})
    public String remindUsername(Model model) {
        model.addAttribute("form", (Object)new RequestByEmailForm());
        model.addAttribute("siteKey", (Object)this.google.getKey());
        return "remind-username";
    }

    @PostMapping(value={"/remind-username"})
    public String remindUsername(HttpServletRequest request, Model model, RequestByEmailForm form) {
        String path = "remind-username";
        if (form.validate(this.ldapService, this.validationService, model, request.getParameter("g-recaptcha-response"))) {
            User user = this.ldapService.getUserByEmail(form.getEmail());
            if (user == null) {
                model.addAttribute("server_error", (Object)"Your account is not activated.");
            } else {
                this.userVerificationService.sendUsernameReminder(model, this.userVerificationService.create(user.getUsername()), form.getEmail());
                if (!model.containsAttribute("server_error")) {
                    request.getSession().setAttribute("email-success", (Object)true);
                    path = "redirect:/email-success";
                }
            }
        }
        return this.redirect(model, (Form)form, path);
    }

    @GetMapping(value={"/forgot-password"})
    public String forgotPassword(Model model) {
        model.addAttribute("form", (Object)new RequestByEmailForm());
        model.addAttribute("siteKey", (Object)this.google.getKey());
        return "forgot-password";
    }

    @PostMapping(value={"/forgot-password"})
    public String forgotPassword(HttpServletRequest request, Model model, RequestByEmailForm form) {
        String path = "forgot-password";
        if (form.validate(this.ldapService, this.validationService, model, request.getParameter("g-recaptcha-response"))) {
            User user = this.ldapService.getUserByEmail(form.getEmail());
            if (user == null) {
                model.addAttribute("server_error", (Object)"Your account is not activated.");
            } else {
                this.userVerificationService.sendForgotPasswordVerification(request, model, this.userVerificationService.create(user.getUsername()), form.getEmail());
                if (!model.containsAttribute("server_error")) {
                    path = "verify";
                }
            }
        }
        return this.redirect(model, (Form)form, path);
    }

    @GetMapping(value={"/reset-password"})
    public String resetPassword(HttpServletRequest request, Model model) {
        String username = (String)request.getSession().getAttribute("username");
        if (username != null) {
            request.getSession().removeAttribute("username");
            model.addAttribute("form", (Object)new ResetPasswordForm(username));
            model.addAttribute("siteKey", (Object)this.google.getKey());
            return "reset-password";
        }
        return "redirect:/error";
    }

    @PostMapping(value={"/reset-password"})
    public String resetPassword(HttpServletRequest request, Model model, ResetPasswordForm form) {
        String path = "reset-password";
        if (form.validate(this.ldapService, this.validationService, model, request.getParameter("g-recaptcha-response"))) {
            String error = this.ldapService.updateUserPassword(form.getUsername(), form.getPassword());
            if (error != null) {
                model.addAttribute("server_error", (Object)error);
            } else {
                request.getSession().setAttribute("password-success", (Object)true);
                path = "redirect:/password-success";
            }
        }
        return this.redirect(model, (Form)form, path);
    }

    private String redirect(Model model, Form form, String path) {
        form.clearPassword();
        model.addAttribute("form", (Object)form);
        model.addAttribute("siteKey", (Object)this.google.getKey());
        return path;
    }
}

